/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.adobe.AdobeJpegReader;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jfif.JfifReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegReader;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.xmp.XmpReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegMetadataReader {
    public static final Iterable<JpegSegmentMetadataReader> ALL_READERS = Arrays.asList(new JpegReader(), new JpegCommentReader(), new JfifReader(), new ExifReader(), new XmpReader(), new IccReader(), new PhotoshopReader(), new IptcReader(), new AdobeJpegReader());

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, @Nullable Iterable<JpegSegmentMetadataReader> iterable) throws JpegProcessingException, IOException {
        Metadata metadata = new Metadata();
        JpegMetadataReader.process(metadata, inputStream, iterable);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws JpegProcessingException, IOException {
        return JpegMetadataReader.readMetadata(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file, @Nullable Iterable<JpegSegmentMetadataReader> iterable) throws JpegProcessingException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Metadata metadata = JpegMetadataReader.readMetadata(fileInputStream, iterable);
            return metadata;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws JpegProcessingException, IOException {
        return JpegMetadataReader.readMetadata(file, null);
    }

    public static void process(@NotNull Metadata metadata, @NotNull InputStream inputStream) throws JpegProcessingException, IOException {
        JpegMetadataReader.process(metadata, inputStream, null);
    }

    public static void process(@NotNull Metadata metadata, @NotNull InputStream inputStream, @Nullable Iterable<JpegSegmentMetadataReader> iterable) throws JpegProcessingException, IOException {
        if (iterable == null) {
            iterable = ALL_READERS;
        }
        HashSet<JpegSegmentType> hashSet = new HashSet<JpegSegmentType>();
        for (JpegSegmentMetadataReader jpegSegmentMetadataReader : iterable) {
            for (JpegSegmentType jpegSegmentType : jpegSegmentMetadataReader.getSegmentTypes()) {
                hashSet.add(jpegSegmentType);
            }
        }
        JpegSegmentData jpegSegmentData = JpegSegmentReader.readSegments(new StreamReader(inputStream), hashSet);
        JpegMetadataReader.processJpegSegmentData(metadata, iterable, jpegSegmentData);
    }

    public static void processJpegSegmentData(Metadata metadata, Iterable<JpegSegmentMetadataReader> iterable, JpegSegmentData jpegSegmentData) {
        for (JpegSegmentMetadataReader jpegSegmentMetadataReader : iterable) {
            for (JpegSegmentType jpegSegmentType : jpegSegmentMetadataReader.getSegmentTypes()) {
                for (byte[] byArray : jpegSegmentData.getSegments(jpegSegmentType)) {
                    if (!jpegSegmentMetadataReader.canProcess(byArray, jpegSegmentType)) continue;
                    jpegSegmentMetadataReader.extract(byArray, metadata, jpegSegmentType);
                }
            }
        }
    }

    private JpegMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }
}

