/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.icc;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.icc.IccDirectory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IccReader
implements JpegSegmentMetadataReader,
MetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP2);
    }

    @Override
    public boolean canProcess(@NotNull byte[] byArray, @NotNull JpegSegmentType jpegSegmentType) {
        return byArray.length > 10 && "ICC_PROFILE".equalsIgnoreCase(new String(byArray, 0, 11));
    }

    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        byte[] byArray2 = new byte[byArray.length - 14];
        System.arraycopy(byArray, 14, byArray2, 0, byArray.length - 14);
        this.extract(new ByteArrayReader(byArray2), metadata);
    }

    @Override
    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata) {
        IccDirectory iccDirectory = metadata.getOrCreateDirectory(IccDirectory.class);
        try {
            iccDirectory.setInt(0, randomAccessReader.getInt32(0));
            this.set4ByteString(iccDirectory, 4, randomAccessReader);
            this.setInt32(iccDirectory, 8, randomAccessReader);
            this.set4ByteString(iccDirectory, 12, randomAccessReader);
            this.set4ByteString(iccDirectory, 16, randomAccessReader);
            this.set4ByteString(iccDirectory, 20, randomAccessReader);
            this.setDate(iccDirectory, 24, randomAccessReader);
            this.set4ByteString(iccDirectory, 36, randomAccessReader);
            this.set4ByteString(iccDirectory, 40, randomAccessReader);
            this.setInt32(iccDirectory, 44, randomAccessReader);
            this.set4ByteString(iccDirectory, 48, randomAccessReader);
            int n = randomAccessReader.getInt32(52);
            if (n != 0) {
                if (n <= 0x20202020) {
                    iccDirectory.setInt(52, n);
                } else {
                    iccDirectory.setString(52, IccReader.getStringFromInt32(n));
                }
            }
            this.setInt32(iccDirectory, 64, randomAccessReader);
            this.setInt64(iccDirectory, 56, randomAccessReader);
            float[] fArray = new float[]{randomAccessReader.getS15Fixed16(68), randomAccessReader.getS15Fixed16(72), randomAccessReader.getS15Fixed16(76)};
            iccDirectory.setObject(68, fArray);
            int n2 = randomAccessReader.getInt32(128);
            iccDirectory.setInt(128, n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = 132 + i * 12;
                int n4 = randomAccessReader.getInt32(n3);
                int n5 = randomAccessReader.getInt32(n3 + 4);
                int n6 = randomAccessReader.getInt32(n3 + 8);
                byte[] byArray = randomAccessReader.getBytes(n5, n6);
                iccDirectory.setByteArray(n4, byArray);
            }
        }
        catch (IOException iOException) {
            iccDirectory.addError("Exception reading ICC profile: " + iOException.getMessage());
        }
    }

    private void set4ByteString(@NotNull Directory directory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        int n2 = randomAccessReader.getInt32(n);
        if (n2 != 0) {
            directory.setString(n, IccReader.getStringFromInt32(n2));
        }
    }

    private void setInt32(@NotNull Directory directory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        int n2 = randomAccessReader.getInt32(n);
        if (n2 != 0) {
            directory.setInt(n, n2);
        }
    }

    private void setInt64(@NotNull Directory directory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        long l = randomAccessReader.getInt64(n);
        if (l != 0L) {
            directory.setLong(n, l);
        }
    }

    private void setDate(@NotNull IccDirectory iccDirectory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        int n2 = randomAccessReader.getUInt16(n);
        int n3 = randomAccessReader.getUInt16(n + 2);
        int n4 = randomAccessReader.getUInt16(n + 4);
        int n5 = randomAccessReader.getUInt16(n + 6);
        int n6 = randomAccessReader.getUInt16(n + 8);
        int n7 = randomAccessReader.getUInt16(n + 10);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(n2, n3, n4, n5, n6, n7);
        Date date = calendar.getTime();
        iccDirectory.setDate(n, date);
    }

    @NotNull
    public static String getStringFromInt32(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return new String(byArray);
    }
}

