/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.iptc.Iso2022Converter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IptcReader
implements JpegSegmentMetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APPD);
    }

    @Override
    public boolean canProcess(@NotNull byte[] byArray, @NotNull JpegSegmentType jpegSegmentType) {
        return byArray.length != 0 && byArray[0] == 28;
    }

    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        this.extract(new SequentialByteArrayReader(byArray), metadata, byArray.length);
    }

    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata, long l) {
        IptcDirectory iptcDirectory = metadata.getOrCreateDirectory(IptcDirectory.class);
        int n = 0;
        while ((long)n < l) {
            int n2;
            short s;
            short s2;
            short s3;
            try {
                s3 = sequentialReader.getUInt8();
                ++n;
            }
            catch (IOException iOException) {
                iptcDirectory.addError("Unable to read starting byte of IPTC tag");
                return;
            }
            if (s3 != 28) {
                if ((long)n != l) {
                    iptcDirectory.addError("Invalid start to IPTC tag");
                }
                return;
            }
            if ((long)(n + 5) >= l) {
                iptcDirectory.addError("Too few bytes remain for a valid IPTC tag");
                return;
            }
            try {
                s2 = sequentialReader.getUInt8();
                s = sequentialReader.getUInt8();
                n2 = sequentialReader.getUInt16();
            }
            catch (IOException iOException) {
                iptcDirectory.addError("IPTC data segment ended mid-way through tag descriptor");
                return;
            }
            if ((long)((n += 4) + n2) > l) {
                iptcDirectory.addError("Data for tag extends beyond end of IPTC segment");
                return;
            }
            try {
                this.processTag(sequentialReader, iptcDirectory, s2, s, n2);
            }
            catch (IOException iOException) {
                iptcDirectory.addError("Error processing IPTC tag");
                return;
            }
            n += n2;
        }
    }

    private void processTag(@NotNull SequentialReader sequentialReader, @NotNull Directory directory, int n, int n2, int n3) throws IOException {
        Object[] objectArray;
        Object object;
        int n4 = n2 | n << 8;
        String string = null;
        switch (n4) {
            case 346: {
                directory.setString(n4, Iso2022Converter.convertISO2022CharsetToJavaCharset(sequentialReader.getBytes(n3)));
                return;
            }
            case 256: 
            case 512: {
                int n5 = sequentialReader.getUInt16();
                sequentialReader.skip(n3 - 2);
                directory.setInt(n4, n5);
                return;
            }
            case 522: {
                directory.setInt(n4, sequentialReader.getUInt8());
                sequentialReader.skip(n3 - 1);
                return;
            }
            case 542: 
            case 567: {
                if (n3 >= 8) {
                    string = sequentialReader.getString(n3);
                    try {
                        int n6 = Integer.parseInt(string.substring(0, 4));
                        int n7 = Integer.parseInt(string.substring(4, 6)) - 1;
                        int n8 = Integer.parseInt(string.substring(6, 8));
                        Date date = new GregorianCalendar(n6, n7, n8).getTime();
                        directory.setDate(n4, date);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                sequentialReader.skip(n3);
            }
        }
        if (string == null) {
            object = directory.getString(346);
            if (object != null) {
                string = sequentialReader.getString(n3, (String)object);
            } else {
                objectArray = sequentialReader.getBytes(n3);
                object = Iso2022Converter.guessEncoding(objectArray);
                String string2 = string = object != null ? new String((byte[])objectArray, (String)object) : new String((byte[])objectArray);
            }
        }
        if (directory.containsTag(n4)) {
            object = directory.getStringArray(n4);
            if (object == null) {
                objectArray = new String[1];
            } else {
                objectArray = new String[((String[])object).length + 1];
                System.arraycopy(object, 0, objectArray, 0, ((String[])object).length);
            }
            objectArray[objectArray.length - 1] = (byte)string;
            directory.setStringArray(n4, (String[])objectArray);
        } else {
            directory.setString(n4, string);
        }
    }
}

