/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.xmp.XmpDirectory;
import java.util.Arrays;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpReader
implements JpegSegmentMetadataReader {
    private static final int FMT_STRING = 1;
    private static final int FMT_RATIONAL = 2;
    private static final int FMT_INT = 3;
    private static final int FMT_DOUBLE = 4;
    @NotNull
    private static final String SCHEMA_XMP_PROPERTIES = "http://ns.adobe.com/xap/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_SPECIFIC_PROPERTIES = "http://ns.adobe.com/exif/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_ADDITIONAL_PROPERTIES = "http://ns.adobe.com/exif/1.0/aux/";
    @NotNull
    private static final String SCHEMA_EXIF_TIFF_PROPERTIES = "http://ns.adobe.com/tiff/1.0/";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP1);
    }

    @Override
    public boolean canProcess(@NotNull byte[] byArray, @NotNull JpegSegmentType jpegSegmentType) {
        return byArray.length > 27 && SCHEMA_XMP_PROPERTIES.equalsIgnoreCase(new String(byArray, 0, 28));
    }

    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        XmpDirectory xmpDirectory = metadata.getOrCreateDirectory(XmpDirectory.class);
        if (byArray.length <= 30) {
            xmpDirectory.addError(String.format("Xmp data segment must contain at least %d bytes", 30));
            return;
        }
        String string = new String(byArray, 0, 29);
        if (!"http://ns.adobe.com/xap/1.0/\u0000".equals(string)) {
            xmpDirectory.addError("XMP data segment doesn't begin with 'http://ns.adobe.com/xap/1.0/'");
            return;
        }
        byte[] byArray2 = new byte[byArray.length - 29];
        System.arraycopy(byArray, 29, byArray2, 0, byArray2.length);
        this.extract(byArray2, metadata);
    }

    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata) {
        XmpDirectory xmpDirectory = metadata.getOrCreateDirectory(XmpDirectory.class);
        try {
            XMPMeta xMPMeta = XMPMetaFactory.parseFromBuffer((byte[])byArray);
            XmpReader.processXmpTags(xmpDirectory, xMPMeta);
        }
        catch (XMPException xMPException) {
            xmpDirectory.addError("Error processing XMP data: " + xMPException.getMessage());
        }
    }

    public void extract(@NotNull String string, @NotNull Metadata metadata) {
        XmpDirectory xmpDirectory = metadata.getOrCreateDirectory(XmpDirectory.class);
        try {
            XMPMeta xMPMeta = XMPMetaFactory.parseFromString((String)string);
            XmpReader.processXmpTags(xmpDirectory, xMPMeta);
        }
        catch (XMPException xMPException) {
            xmpDirectory.addError("Error processing XMP data: " + xMPException.getMessage());
        }
    }

    private static void processXmpTags(XmpDirectory xmpDirectory, XMPMeta xMPMeta) throws XMPException {
        xmpDirectory.setXMPMeta(xMPMeta);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:LensInfo", 6, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Lens", 7, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:SerialNumber", 8, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Firmware", 9, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Make", 1, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Model", 2, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureTime", 3, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureProgram", 12, 3);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ApertureValue", 11, 2);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FNumber", 5, 2);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FocalLength", 10, 2);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ShutterSpeedValue", 4, 2);
        XmpReader.processXmpDateTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeOriginal", 13);
        XmpReader.processXmpDateTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeDigitized", 14);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_XMP_PROPERTIES, "xmp:Rating", 4097, 4);
        for (XMPPropertyInfo xMPPropertyInfo : xMPMeta) {
            String string = xMPPropertyInfo.getPath();
            String string2 = xMPPropertyInfo.getValue();
            if (string == null || string2 == null) continue;
            xmpDirectory.addProperty(string, string2);
        }
    }

    private static void processXmpTag(@NotNull XMPMeta xMPMeta, @NotNull XmpDirectory xmpDirectory, @NotNull String string, @NotNull String string2, int n, int n2) throws XMPException {
        String string3 = xMPMeta.getPropertyString(string, string2);
        if (string3 == null) {
            return;
        }
        switch (n2) {
            case 2: {
                String[] stringArray = string3.split("/", 2);
                if (stringArray.length == 2) {
                    try {
                        Rational rational = new Rational((long)Float.parseFloat(stringArray[0]), (long)Float.parseFloat(stringArray[1]));
                        xmpDirectory.setRational(n, rational);
                    }
                    catch (NumberFormatException numberFormatException) {
                        xmpDirectory.addError(String.format("Unable to parse XMP property %s as a Rational.", string2));
                    }
                    break;
                }
                xmpDirectory.addError("Error in rational format for tag " + n);
                break;
            }
            case 3: {
                try {
                    xmpDirectory.setInt(n, Integer.valueOf(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    xmpDirectory.addError(String.format("Unable to parse XMP property %s as an int.", string2));
                }
                break;
            }
            case 4: {
                try {
                    xmpDirectory.setDouble(n, Double.valueOf(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    xmpDirectory.addError(String.format("Unable to parse XMP property %s as an double.", string2));
                }
                break;
            }
            case 1: {
                xmpDirectory.setString(n, string3);
                break;
            }
            default: {
                xmpDirectory.addError(String.format("Unknown format code %d for tag %d", n2, n));
            }
        }
    }

    private static void processXmpDateTag(@NotNull XMPMeta xMPMeta, @NotNull XmpDirectory xmpDirectory, @NotNull String string, @NotNull String string2, int n) throws XMPException {
        Calendar calendar = xMPMeta.getPropertyCalendar(string, string2);
        if (calendar != null) {
            xmpDirectory.setDate(n, calendar.getTime());
        }
    }
}

