/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkAttribute;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkEditableTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRange;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRectangle;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class AccessibleObject {
    long handle;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    AccessibleObject[] children;
    boolean isLightweight = false;
    static long actionNamePtr = -1L;
    static long descriptionPtr = -1L;
    static long keybindingPtr = -1L;
    static long namePtr = -1L;
    static final Map<LONG, AccessibleObject> AccessibleObjects = new HashMap<LONG, AccessibleObject>(9);
    static final boolean DEBUG = Device.DEBUG;
    static final int ROW_ROLE = OS.GTK_VERSION >= OS.VERSION(3, 2, 0) ? 88 : ATK.atk_role_register(Converter.wcsToMbcs(null, "row", true));

    AccessibleObject(long l, long l2, Accessible accessible, boolean bl) {
        this.handle = ATK.g_object_new(l, 0L);
        ATK.atk_object_initialize(this.handle, l2);
        this.accessible = accessible;
        this.isLightweight = bl;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            AccessibleObject.print("new AccessibleObject: " + this.handle + " control=" + accessible.control + " lw=" + bl);
        }
    }

    static void print(String string) {
        System.out.println(string);
    }

    static int size(Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    static AtkActionIface getActionIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_ACTION())) {
            AtkActionIface atkActionIface = new AtkActionIface();
            ATK.memmove(atkActionIface, ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(l)));
            return atkActionIface;
        }
        return null;
    }

    static long atkAction_do_action(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_do_action");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleActionListener> list = accessible.accessibleActionListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                accessibleActionEvent.index = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleActionListener accessibleActionListener = list.get(i);
                    accessibleActionListener.doAction(accessibleActionEvent);
                }
                return "OK".equals(accessibleActionEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.do_action != 0L) {
            l3 = ATK.call(atkActionIface.do_action, l, l2);
        }
        return l3;
    }

    static long atkAction_get_n_actions(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_n_actions");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleActionListener> list = accessible.accessibleActionListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleActionListener accessibleActionListener = list.get(i);
                    accessibleActionListener.getActionCount(accessibleActionEvent);
                }
                return accessibleActionEvent.count;
            }
        }
        long l2 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_n_actions != 0L) {
            l2 = ATK.call(atkActionIface.get_n_actions, l);
        }
        return l2;
    }

    static long atkAction_get_description(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_description");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleActionListener> list = accessible.accessibleActionListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                accessibleActionEvent.index = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleActionListener accessibleActionListener = list.get(i);
                    accessibleActionListener.getDescription(accessibleActionEvent);
                }
                if (accessibleActionEvent.result == null) {
                    return 0L;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleActionEvent.result);
                return descriptionPtr;
            }
        }
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_description != 0L) {
            l3 = ATK.call(atkActionIface.get_description, l, l2);
        }
        return l3;
    }

    static long atkAction_get_keybinding(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_keybinding");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_keybinding != 0L) {
            l3 = ATK.call(atkActionIface.get_keybinding, l, l2);
        }
        if (accessibleObject != null) {
            Object object;
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleActionListener> list = accessible.accessibleActionListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                object = new AccessibleActionEvent(accessible);
                ((AccessibleActionEvent)object).index = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleActionListener accessibleActionListener = list.get(i);
                    accessibleActionListener.getKeyBinding((AccessibleActionEvent)object);
                }
                if (((AccessibleActionEvent)object).result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(((AccessibleActionEvent)object).result);
                    return keybindingPtr;
                }
            }
            if ((n = AccessibleObject.size(object = accessible.accessibleListeners)) > 0) {
                AccessibleEvent accessibleEvent = new AccessibleEvent(accessible);
                accessibleEvent.childID = accessibleObject.id;
                if (l3 != 0L) {
                    accessibleEvent.result = AccessibleObject.getString(l3);
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleListener accessibleListener = (AccessibleListener)object.get(i);
                    accessibleListener.getKeyboardShortcut(accessibleEvent);
                }
                if (accessibleEvent.result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(accessibleEvent.result);
                    return keybindingPtr;
                }
            }
        }
        return l3;
    }

    static long atkAction_get_name(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_name");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_name != 0L) {
            l3 = ATK.call(atkActionIface.get_name, l, l2);
        }
        if (accessibleObject != null) {
            Object object;
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleActionListener> list = accessible.accessibleActionListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                object = new AccessibleActionEvent(accessible);
                ((AccessibleActionEvent)object).index = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleActionListener accessibleActionListener = list.get(i);
                    accessibleActionListener.getName((AccessibleActionEvent)object);
                }
                if (((AccessibleActionEvent)object).result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(((AccessibleActionEvent)object).result);
                    return actionNamePtr;
                }
            }
            if (l2 == 0L && (n = AccessibleObject.size(object = accessible.accessibleControlListeners)) > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                if (l3 != 0L) {
                    accessibleControlEvent.result = AccessibleObject.getString(l3);
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)object.get(i);
                    accessibleControlListener.getDefaultAction(accessibleControlEvent);
                }
                if (accessibleControlEvent.result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(accessibleControlEvent.result);
                    return actionNamePtr;
                }
            }
        }
        return l3;
    }

    static AtkComponentIface getComponentIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_COMPONENT())) {
            AtkComponentIface atkComponentIface = new AtkComponentIface();
            ATK.memmove(atkComponentIface, ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(l)));
            return atkComponentIface;
        }
        return null;
    }

    static long atkComponent_get_extents(long l, long l2, long l3, long l4, long l5, long l6) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_extents: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        OS.memmove(l2, new int[]{0}, 4L);
        OS.memmove(l3, new int[]{0}, 4L);
        OS.memmove(l4, new int[]{0}, 4L);
        OS.memmove(l5, new int[]{0}, 4L);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.get_extents != 0L) {
            ATK.call(atkComponentIface.get_extents, l, l2, l3, l4, l5, l6);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.memmove(nArray, l2, 4L);
                OS.memmove(nArray2, l3, 4L);
                OS.memmove(nArray3, l4, 4L);
                OS.memmove(nArray4, l5, 4L);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = nArray[0];
                accessibleControlEvent.y = nArray2[0];
                accessibleControlEvent.width = nArray3[0];
                accessibleControlEvent.height = nArray4[0];
                int[] nArray5 = new int[1];
                int[] nArray6 = new int[1];
                if (l6 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray5, nArray6);
                    accessibleControlEvent.x += nArray5[0];
                    accessibleControlEvent.y += nArray6[0];
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = list.get(i);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                }
                if (l6 == 1L) {
                    accessibleControlEvent.x -= nArray5[0];
                    accessibleControlEvent.y -= nArray6[0];
                }
                OS.memmove(l2, new int[]{accessibleControlEvent.x}, 4L);
                OS.memmove(l3, new int[]{accessibleControlEvent.y}, 4L);
                OS.memmove(l4, new int[]{accessibleControlEvent.width}, 4L);
                OS.memmove(l5, new int[]{accessibleControlEvent.height}, 4L);
                if (DEBUG) {
                    AccessibleObject.print("--->" + accessibleControlEvent.x + "," + accessibleControlEvent.y + "," + accessibleControlEvent.width + "x" + accessibleControlEvent.height);
                }
            }
        }
        return 0L;
    }

    static long atkComponent_get_position(long l, long l2, long l3, long l4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_position, object: " + l + " x: " + l2 + " y: " + l3 + " coord: " + l4);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        OS.memmove(l2, new int[]{0}, 4L);
        OS.memmove(l3, new int[]{0}, 4L);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.get_position != 0L) {
            ATK.call(atkComponentIface.get_position, l, l2, l3, l4);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.memmove(nArray, l2, 4L);
                OS.memmove(nArray2, l3, 4L);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = nArray[0];
                accessibleControlEvent.y = nArray2[0];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray3, nArray4);
                    accessibleControlEvent.x += nArray3[0];
                    accessibleControlEvent.y += nArray4[0];
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = list.get(i);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                }
                if (l4 == 1L) {
                    accessibleControlEvent.x -= nArray3[0];
                    accessibleControlEvent.y -= nArray4[0];
                }
                OS.memmove(l2, new int[]{accessibleControlEvent.x}, 4L);
                OS.memmove(l3, new int[]{accessibleControlEvent.y}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_get_size(long l, long l2, long l3, long l4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_size");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        OS.memmove(l2, new int[]{0}, 4L);
        OS.memmove(l3, new int[]{0}, 4L);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.get_size != 0L) {
            ATK.call(atkComponentIface.get_size, l, l2, l3, l4);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.memmove(nArray, l2, 4L);
                OS.memmove(nArray2, l3, 4L);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.width = nArray[0];
                accessibleControlEvent.height = nArray2[0];
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = list.get(i);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                }
                OS.memmove(l2, new int[]{accessibleControlEvent.width}, 4L);
                OS.memmove(l3, new int[]{accessibleControlEvent.height}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_ref_accessible_at_point(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_ref_accessible_at_point: " + l + " " + l2 + "," + l3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Accessible accessible2;
                Object object;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = (int)l2;
                accessibleControlEvent.y = (int)l3;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, nArray2);
                    accessibleControlEvent.x += nArray[0];
                    accessibleControlEvent.y += nArray2[0];
                }
                for (int i = 0; i < n; ++i) {
                    object = list.get(i);
                    object.getChildAtPoint(accessibleControlEvent);
                }
                if (accessibleControlEvent.childID == accessibleObject.id) {
                    accessibleControlEvent.childID = -1;
                }
                Object object2 = object = (accessible2 = accessibleControlEvent.accessible) != null ? accessible2.getAccessibleObject() : accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (object != null) {
                    return OS.g_object_ref(((AccessibleObject)object).handle);
                }
            }
        }
        long l5 = 0L;
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.ref_accessible_at_point != 0L) {
            l5 = ATK.call(atkComponentIface.ref_accessible_at_point, l, l2, l3, l4);
        }
        return l5;
    }

    static AtkEditableTextIface getEditableTextIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_EDITABLE_TEXT())) {
            AtkEditableTextIface atkEditableTextIface = new AtkEditableTextIface();
            ATK.memmove(atkEditableTextIface, ATK.g_type_interface_peek_parent(ATK.ATK_EDITABLE_TEXT_GET_IFACE(l)));
            return atkEditableTextIface;
        }
        return null;
    }

    static long atkEditableText_set_run_attributes(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_set_run_attributes");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleEditableTextListener> list = accessible.accessibleEditableTextListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Display display = accessible.control.getDisplay();
                long l5 = OS.pango_font_description_new();
                boolean bl = false;
                TextStyle textStyle = new TextStyle();
                String[] stringArray = new String[]{};
                long l6 = l2;
                int n2 = OS.g_slist_length(l2);
                for (int i = 0; i < n2; ++i) {
                    long l7 = OS.g_slist_data(l6);
                    if (l7 != 0L) {
                        AtkAttribute atkAttribute = new AtkAttribute();
                        ATK.memmove(atkAttribute, l7, AtkAttribute.sizeof);
                        String string = AccessibleObject.getString(atkAttribute.name);
                        String string2 = AccessibleObject.getString(atkAttribute.value);
                        OS.g_free(l7);
                        if (DEBUG) {
                            AccessibleObject.print("name=" + string + ", value=" + string2);
                        }
                        String[] stringArray2 = new String[stringArray.length + 2];
                        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                        stringArray2[stringArray.length] = string;
                        stringArray2[stringArray.length + 1] = string2;
                        stringArray = stringArray2;
                        try {
                            if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(10)))) {
                                textStyle.rise = Integer.parseInt(string2);
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(11)))) {
                                if (string2.equals("single") || string2.equals("low")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 0;
                                } else if (string2.equals("double")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 1;
                                } else if (string2.equals("error")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 2;
                                } else if (string2.equals("squiggle")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 3;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(12)))) {
                                if (string2.equals("true") || string2.equals("1") || string2.equals("single")) {
                                    textStyle.strikeout = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(17)))) {
                                byte[] byArray = Converter.wcsToMbcs(null, string2, true);
                                OS.pango_font_description_set_family(l5, byArray);
                                bl = true;
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(13)))) {
                                float f = Float.parseFloat(string2);
                                OS.pango_font_description_set_size(l5, (int)(f * 1024.0f));
                                bl = true;
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(27)))) {
                                int n3 = -1;
                                if (string2.equals("normal")) {
                                    n3 = 0;
                                } else if (string2.equals("italic")) {
                                    n3 = 2;
                                } else if (string2.equals("oblique")) {
                                    n3 = 1;
                                }
                                if (n3 != -1) {
                                    OS.pango_font_description_set_style(l5, n3);
                                    bl = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(26)))) {
                                int n4 = -1;
                                if (string2.equals("normal")) {
                                    n4 = 0;
                                } else if (string2.equals("small_caps")) {
                                    n4 = 1;
                                }
                                if (n4 != -1) {
                                    OS.pango_font_description_set_variant(l5, n4);
                                    bl = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(25)))) {
                                int n5 = -1;
                                if (string2.equals("ultra_condensed")) {
                                    n5 = 0;
                                } else if (string2.equals("extra_condensed")) {
                                    n5 = 1;
                                } else if (string2.equals("condensed")) {
                                    n5 = 2;
                                } else if (string2.equals("semi_condensed")) {
                                    n5 = 3;
                                } else if (string2.equals("normal")) {
                                    n5 = 4;
                                } else if (string2.equals("semi_expanded")) {
                                    n5 = 5;
                                } else if (string2.equals("expanded")) {
                                    n5 = 6;
                                } else if (string2.equals("extra_expanded")) {
                                    n5 = 7;
                                } else if (string2.equals("ultra_expanded")) {
                                    n5 = 8;
                                }
                                if (n5 != -1) {
                                    OS.pango_font_description_set_stretch(l5, n5);
                                    bl = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(15)))) {
                                int n6 = Integer.parseInt(string2);
                                OS.pango_font_description_set_weight(l5, n6);
                                bl = true;
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(19)))) {
                                textStyle.foreground = AccessibleObject.colorFromString(display, string2);
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(18)))) {
                                textStyle.background = AccessibleObject.colorFromString(display, string2);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    l6 = OS.g_slist_next(l6);
                }
                if (bl) {
                    textStyle.font = Font.gtk_new(display, l5);
                }
                AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(accessible);
                accessibleTextAttributeEvent.start = (int)l3;
                accessibleTextAttributeEvent.end = (int)l4;
                accessibleTextAttributeEvent.textStyle = textStyle;
                accessibleTextAttributeEvent.attributes = stringArray;
                for (int i = 0; i < n; ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = list.get(i);
                    accessibleEditableTextListener.setTextAttributes(accessibleTextAttributeEvent);
                }
                if (textStyle.font != null) {
                    textStyle.font.dispose();
                }
                if (textStyle.foreground != null) {
                    textStyle.foreground.dispose();
                }
                if (textStyle.background != null) {
                    textStyle.background.dispose();
                }
                return "OK".equals(accessibleTextAttributeEvent.result) ? 1L : 0L;
            }
        }
        long l8 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.set_run_attributes != 0L) {
            l8 = ATK.call(atkEditableTextIface.set_run_attributes, l, l2, l3, l4);
        }
        return l8;
    }

    static Color colorFromString(Display display, String string) {
        try {
            int n = string.indexOf(44);
            int n2 = string.indexOf(44, n + 1);
            int n3 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1, string.length()));
            return new Color(display, n3, n4, n5);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static long atkEditableText_set_text_contents(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_set_text_contents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleEditableTextListener> list = accessible.accessibleEditableTextListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = 0;
                String string = accessibleObject.getText();
                accessibleEditableTextEvent.end = string == null ? 0 : string.length();
                accessibleEditableTextEvent.string = AccessibleObject.getString(l2);
                for (int i = 0; i < n; ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = list.get(i);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.set_text_contents != 0L) {
            l3 = ATK.call(atkEditableTextIface.set_text_contents, l, l2);
        }
        return l3;
    }

    static long atkEditableText_insert_text(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_insert_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleEditableTextListener> list = accessible.accessibleEditableTextListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                int[] nArray = new int[1];
                OS.memmove(nArray, l4, (long)OS.PTR_SIZEOF);
                accessibleEditableTextEvent.start = accessibleEditableTextEvent.end = nArray[0];
                accessibleEditableTextEvent.string = AccessibleObject.getString(l2);
                for (int i = 0; i < n; ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = list.get(i);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1L : 0L;
            }
        }
        long l5 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.insert_text != 0L) {
            l5 = ATK.call(atkEditableTextIface.insert_text, l, l2, l3, l4);
        }
        return l5;
    }

    static long atkEditableText_copy_text(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_copy_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleEditableTextListener> list = accessible.accessibleEditableTextListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                accessibleEditableTextEvent.end = (int)l3;
                for (int i = 0; i < n; ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = list.get(i);
                    accessibleEditableTextListener.copyText(accessibleEditableTextEvent);
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1L : 0L;
            }
        }
        long l4 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.copy_text != 0L) {
            l4 = ATK.call(atkEditableTextIface.copy_text, l, l2, l3);
        }
        return l4;
    }

    static long atkEditableText_cut_text(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_cut_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleEditableTextListener> list = accessible.accessibleEditableTextListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                accessibleEditableTextEvent.end = (int)l3;
                for (int i = 0; i < n; ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = list.get(i);
                    accessibleEditableTextListener.cutText(accessibleEditableTextEvent);
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1L : 0L;
            }
        }
        long l4 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.cut_text != 0L) {
            l4 = ATK.call(atkEditableTextIface.cut_text, l, l2, l3);
        }
        return l4;
    }

    static long atkEditableText_delete_text(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_delete_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleEditableTextListener> list = accessible.accessibleEditableTextListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                accessibleEditableTextEvent.end = (int)l3;
                accessibleEditableTextEvent.string = "";
                for (int i = 0; i < n; ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = list.get(i);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1L : 0L;
            }
        }
        long l4 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.delete_text != 0L) {
            l4 = ATK.call(atkEditableTextIface.delete_text, l, l2, l3);
        }
        return l4;
    }

    static long atkEditableText_paste_text(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_paste_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleEditableTextListener> list = accessible.accessibleEditableTextListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = list.get(i);
                    accessibleEditableTextListener.pasteText(accessibleEditableTextEvent);
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.paste_text != 0L) {
            l3 = ATK.call(atkEditableTextIface.paste_text, l, l2);
        }
        return l3;
    }

    static AtkHypertextIface getHypertextIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_HYPERTEXT())) {
            AtkHypertextIface atkHypertextIface = new AtkHypertextIface();
            ATK.memmove(atkHypertextIface, ATK.g_type_interface_peek_parent(ATK.ATK_HYPERTEXT_GET_IFACE(l)));
            return atkHypertextIface;
        }
        return null;
    }

    static long atkHypertext_get_link(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getHyperlink(accessibleTextEvent);
                }
                Accessible accessible2 = accessibleTextEvent.accessible;
                return accessible2 != null ? accessible2.getAccessibleObject().handle : 0L;
            }
        }
        long l3 = 0L;
        AtkHypertextIface atkHypertextIface = AccessibleObject.getHypertextIface(l);
        if (atkHypertextIface != null && atkHypertextIface.get_link != 0L) {
            l3 = ATK.call(atkHypertextIface.get_link, l, l2);
        }
        return l3;
    }

    static long atkHypertext_get_n_links(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_n_links");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getHyperlinkCount(accessibleTextEvent);
                }
                return accessibleTextEvent.count;
            }
        }
        long l2 = 0L;
        AtkHypertextIface atkHypertextIface = AccessibleObject.getHypertextIface(l);
        if (atkHypertextIface != null && atkHypertextIface.get_n_links != 0L) {
            l2 = ATK.call(atkHypertextIface.get_n_links, l);
        }
        return l2;
    }

    static long atkHypertext_get_link_index(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link_index");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.offset = (int)l2;
                accessibleTextEvent.index = -1;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getHyperlinkIndex(accessibleTextEvent);
                }
                return accessibleTextEvent.index;
            }
        }
        long l3 = 0L;
        AtkHypertextIface atkHypertextIface = AccessibleObject.getHypertextIface(l);
        if (atkHypertextIface != null && atkHypertextIface.get_link_index != 0L) {
            l3 = ATK.call(atkHypertextIface.get_link_index, l, l2);
        }
        return l3;
    }

    static AtkObjectClass getObjectClass(long l) {
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, ATK.g_type_class_peek(OS.g_type_parent(OS.G_OBJECT_TYPE(l))));
        return atkObjectClass;
    }

    static long atkObject_get_description(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_description: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_description != 0L) {
            l2 = ATK.call(atkObjectClass.get_description, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleListener> list = accessible.accessibleListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEvent accessibleEvent = new AccessibleEvent(accessible);
                accessibleEvent.childID = accessibleObject.id;
                if (l2 != 0L) {
                    accessibleEvent.result = AccessibleObject.getString(l2);
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleListener accessibleListener = list.get(i);
                    accessibleListener.getDescription(accessibleEvent);
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleEvent.result);
                }
                if (accessibleEvent.result == null) {
                    return l2;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleEvent.result);
                return descriptionPtr;
            }
        }
        return l2;
    }

    static long atkObject_get_attributes(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_attributes: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_attributes != 0L) {
            l2 = ATK.call(atkObjectClass.get_attributes, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleAttributeListener> list = accessible.accessibleAttributeListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Control control;
                int n2;
                AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(accessible);
                accessibleAttributeEvent.groupIndex = -1;
                accessibleAttributeEvent.groupCount = -1;
                accessibleAttributeEvent.groupLevel = -1;
                accessibleAttributeEvent.indent = -1;
                accessibleAttributeEvent.alignment = -1;
                accessibleAttributeEvent.rightMargin = -1;
                accessibleAttributeEvent.leftMargin = -1;
                accessibleAttributeEvent.bottomMargin = -1;
                accessibleAttributeEvent.topMargin = -1;
                for (int i = 0; i < n; ++i) {
                    AccessibleAttributeListener accessibleAttributeListener = list.get(i);
                    accessibleAttributeListener.getAttributes(accessibleAttributeEvent);
                }
                AtkAttribute atkAttribute = new AtkAttribute();
                if (accessibleAttributeEvent.leftMargin != -1) {
                    long l3 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(1));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.leftMargin));
                    ATK.memmove(l3, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l3);
                }
                if (accessibleAttributeEvent.rightMargin != -1) {
                    long l4 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(2));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.rightMargin));
                    ATK.memmove(l4, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l4);
                }
                if (accessibleAttributeEvent.topMargin != -1) {
                    long l5 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("top-margin");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.topMargin));
                    ATK.memmove(l5, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l5);
                }
                if (accessibleAttributeEvent.bottomMargin != -1) {
                    long l6 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("bottom-margin");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.bottomMargin));
                    ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l6);
                }
                if (accessibleAttributeEvent.indent != -1) {
                    long l7 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(3));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.indent));
                    ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l7);
                }
                if (accessibleAttributeEvent.justify) {
                    long l8 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    atkAttribute.value = AccessibleObject.getStringPtr("fill");
                    ATK.memmove(l8, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l8);
                } else if (accessibleAttributeEvent.alignment != -1) {
                    long l9 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    String string = "left";
                    switch (accessibleAttributeEvent.alignment) {
                        case 16384: {
                            string = "left";
                            break;
                        }
                        case 131072: {
                            string = "right";
                            break;
                        }
                        case 0x1000000: {
                            string = "center";
                        }
                    }
                    atkAttribute.value = AccessibleObject.getStringPtr(string);
                    ATK.memmove(l9, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l9);
                }
                int n3 = accessibleAttributeEvent.groupLevel != -1 ? accessibleAttributeEvent.groupLevel : 0;
                int n4 = accessibleAttributeEvent.groupCount != -1 ? accessibleAttributeEvent.groupCount : 0;
                int n5 = n2 = accessibleAttributeEvent.groupIndex != -1 ? accessibleAttributeEvent.groupIndex : 0;
                if (n4 == 0 && n2 == 0 && (control = accessible.control) instanceof Button && (control.getStyle() & 0x10) != 0) {
                    Control[] controlArray = control.getParent().getChildren();
                    n2 = 1;
                    n4 = 1;
                    for (int i = 0; i < controlArray.length; ++i) {
                        Control control2 = controlArray[i];
                        if (!(control2 instanceof Button) || (control2.getStyle() & 0x10) == 0) continue;
                        if (control2 == control) {
                            n2 = n4;
                            continue;
                        }
                        ++n4;
                    }
                }
                if (n3 != 0) {
                    long l10 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("level");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(n3));
                    ATK.memmove(l10, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l10);
                }
                if (n4 != 0) {
                    long l11 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("setsize");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(n4));
                    ATK.memmove(l11, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l11);
                }
                if (n2 != 0) {
                    long l12 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("posinset");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(n2));
                    ATK.memmove(l12, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l12);
                }
                if (accessibleAttributeEvent.attributes != null) {
                    int n6 = accessibleAttributeEvent.attributes.length / 2 * 2;
                    for (int i = 0; i < n6; i += 2) {
                        long l13 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = AccessibleObject.getStringPtr(accessibleAttributeEvent.attributes[i]);
                        atkAttribute.value = AccessibleObject.getStringPtr(accessibleAttributeEvent.attributes[i + 1]);
                        ATK.memmove(l13, atkAttribute, AtkAttribute.sizeof);
                        l2 = OS.g_slist_append(l2, l13);
                    }
                }
            }
        }
        return l2;
    }

    static long atkObject_get_name(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_name: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_name != 0L) {
            l2 = ATK.call(atkObjectClass.get_name, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleListener> list = accessible.accessibleListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleEvent accessibleEvent = new AccessibleEvent(accessible);
                accessibleEvent.childID = accessibleObject.id;
                if (l2 != 0L) {
                    accessibleEvent.result = AccessibleObject.getString(l2);
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleListener accessibleListener = list.get(i);
                    accessibleListener.getName(accessibleEvent);
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleEvent.result);
                }
                if (accessibleEvent.result == null) {
                    return l2;
                }
                if (namePtr != -1L) {
                    OS.g_free(namePtr);
                }
                namePtr = AccessibleObject.getStringPtr(accessibleEvent.result);
                return namePtr;
            }
        }
        return l2;
    }

    static long atkObject_get_n_children(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_n_children: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_n_children != 0L) {
            l2 = ATK.call(atkObjectClass.get_n_children, l);
        }
        if (accessibleObject != null && accessibleObject.id == -1) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = list.get(i);
                    accessibleControlListener.getChildCount(accessibleControlEvent);
                }
                if (DEBUG) {
                    AccessibleObject.print("--->" + accessibleControlEvent.detail);
                }
                return accessibleControlEvent.detail;
            }
        }
        return l2;
    }

    static long atkObject_get_index_in_parent(long l) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_index_in_parent: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleControlListener> list = ((Accessible)object).accessibleControlListeners;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(object);
            accessibleControlEvent.childID = -5;
            accessibleControlEvent.detail = -1;
            for (int i = 0; i < AccessibleObject.size(list); ++i) {
                AccessibleControlListener accessibleControlListener = list.get(i);
                accessibleControlListener.getChild(accessibleControlEvent);
            }
            if (accessibleControlEvent.detail != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleObject.index);
                }
                return accessibleControlEvent.detail;
            }
            if (accessibleObject.index != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleObject.index);
                }
                return accessibleObject.index;
            }
        }
        object = AccessibleObject.getObjectClass(l);
        if (((AtkObjectClass)object).get_index_in_parent == 0L) {
            return 0L;
        }
        long l2 = ATK.call(((AtkObjectClass)object).get_index_in_parent, l);
        if (DEBUG) {
            AccessibleObject.print("---*> " + l2);
        }
        return l2;
    }

    static long atkObject_get_parent(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_parent: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null && accessibleObject.parent != null) {
            if (DEBUG) {
                AccessibleObject.print("---> " + accessibleObject.parent.accessible.accessibleObject.handle);
            }
            return accessibleObject.parent.handle;
        }
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_parent == 0L) {
            return 0L;
        }
        long l2 = ATK.call(atkObjectClass.get_parent, l);
        if (DEBUG) {
            AccessibleObject.print("---> " + l2);
        }
        return l2;
    }

    static long atkObject_get_role(long l) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_role: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleControlListener> list = ((Accessible)object).accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(object);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = -1;
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = list.get(i);
                    accessibleControlListener.getRole(accessibleControlEvent);
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleControlEvent.detail);
                }
                if (accessibleControlEvent.detail != -1) {
                    switch (accessibleControlEvent.detail) {
                        case 44: {
                            return 7L;
                        }
                        case 10: {
                            return 18L;
                        }
                        case 46: {
                            return 11L;
                        }
                        case 18: {
                            return 16L;
                        }
                        case 41: {
                            return 28L;
                        }
                        case 30: {
                            return 60L;
                        }
                        case 33: {
                            return 30L;
                        }
                        case 34: {
                            return 31L;
                        }
                        case 11: {
                            return 32L;
                        }
                        case 2: {
                            return 33L;
                        }
                        case 12: {
                            return 34L;
                        }
                        case 48: {
                            return 41L;
                        }
                        case 43: {
                            return 42L;
                        }
                        case 3: {
                            return 47L;
                        }
                        case 21: {
                            return 49L;
                        }
                        case 51: {
                            return 50L;
                        }
                        case 24: {
                            return 54L;
                        }
                        case 29: {
                            return 55L;
                        }
                        case 25: {
                            return 56L;
                        }
                        case 26: {
                            return 57L;
                        }
                        case 60: {
                            return 37L;
                        }
                        case 37: {
                            return 36L;
                        }
                        case 42: {
                            return 60L;
                        }
                        case 22: {
                            return 62L;
                        }
                        case 13: {
                            return 63L;
                        }
                        case 35: {
                            return 64L;
                        }
                        case 36: {
                            return 31L;
                        }
                        case 45: {
                            return 43L;
                        }
                        case 62: {
                            return 42L;
                        }
                        case 9: {
                            return 68L;
                        }
                        case 28: {
                            return ROW_ROLE;
                        }
                        case 27: {
                            return 66L;
                        }
                        case 8: {
                            return 2L;
                        }
                        case 54: {
                            return 3L;
                        }
                        case 1025: {
                            return 6L;
                        }
                        case 20: {
                            return 38L;
                        }
                        case 52: {
                            return 52L;
                        }
                        case 23: {
                            return 53L;
                        }
                        case 1027: {
                            return 8L;
                        }
                        case 1073: {
                            return 44L;
                        }
                        case 61: {
                            return 66L;
                        }
                        case 47: {
                            return 4L;
                        }
                        case 1029: {
                            return 12L;
                        }
                        case 1038: {
                            return 70L;
                        }
                        case 1040: {
                            return 85L;
                        }
                        case 1043: {
                            return 69L;
                        }
                        case 1044: {
                            return 81L;
                        }
                        case 1053: {
                            return 82L;
                        }
                        case 1054: {
                            return 71L;
                        }
                        case 1060: {
                            return 83L;
                        }
                        case 15: {
                            return 80L;
                        }
                        case 40: {
                            return 26L;
                        }
                    }
                }
            }
        }
        object = AccessibleObject.getObjectClass(l);
        if (((AtkObjectClass)object).get_role == 0L) {
            return 0L;
        }
        return ATK.call(((AtkObjectClass)object).get_role, l);
    }

    static long atkObject_ref_child(long l, long l2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_child: " + l2 + " of: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null && accessibleObject.id == -1) {
            Object object2;
            object = accessibleObject.accessible;
            List<AccessibleControlListener> list = ((Accessible)object).accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleObject accessibleObject2;
                object2 = new AccessibleControlEvent(object);
                ((AccessibleControlEvent)object2).childID = -4;
                ((AccessibleControlEvent)object2).detail = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = list.get(i);
                    accessibleControlListener.getChild((AccessibleControlEvent)object2);
                }
                if (((AccessibleControlEvent)object2).accessible != null && (accessibleObject2 = ((AccessibleControlEvent)object2).accessible.getAccessibleObject()) != null) {
                    return OS.g_object_ref(accessibleObject2.handle);
                }
            }
            accessibleObject.updateChildren();
            object2 = accessibleObject.getChildByIndex((int)l2);
            if (object2 != null) {
                return OS.g_object_ref(((AccessibleObject)object2).handle);
            }
        }
        object = AccessibleObject.getObjectClass(l);
        if (((AtkObjectClass)object).ref_child == 0L) {
            return 0L;
        }
        return ATK.call(((AtkObjectClass)object).ref_child, l, l2);
    }

    static long atkObject_ref_state_set(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_state_set: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.ref_state_set != 0L) {
            l2 = ATK.call(atkObjectClass.ref_state_set, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int n2;
                long l3 = l2;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = -1;
                for (n2 = 0; n2 < n; ++n2) {
                    AccessibleControlListener accessibleControlListener = list.get(n2);
                    accessibleControlListener.getState(accessibleControlEvent);
                }
                if (accessibleControlEvent.detail != -1) {
                    n2 = accessibleControlEvent.detail;
                    if ((n2 & 0x800) != 0) {
                        ATK.atk_state_set_add_state(l3, 3);
                    }
                    if ((n2 & 0x10) != 0) {
                        ATK.atk_state_set_add_state(l3, 4);
                    }
                    if ((n2 & 0x200) != 0) {
                        ATK.atk_state_set_add_state(l3, 9);
                    }
                    if ((n2 & 0x100000) != 0) {
                        ATK.atk_state_set_add_state(l3, 10);
                    }
                    if ((n2 & 4) != 0) {
                        ATK.atk_state_set_add_state(l3, 11);
                    }
                    if ((n2 & 0x80) != 0) {
                        ATK.atk_state_set_add_state(l3, 2);
                    }
                    if ((n2 & 0x8000) == 0) {
                        ATK.atk_state_set_add_state(l3, 28);
                    }
                    if ((n2 & 0x1000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 16);
                    }
                    if ((n2 & 0x10000) == 0) {
                        ATK.atk_state_set_add_state(l3, 23);
                    }
                    if ((n2 & 8) != 0) {
                        ATK.atk_state_set_add_state(l3, 18);
                    }
                    if ((n2 & 0x40) == 0) {
                        ATK.atk_state_set_add_state(l3, 6);
                    }
                    if ((n2 & 0x200000) != 0) {
                        ATK.atk_state_set_add_state(l3, 20);
                    }
                    if ((n2 & 2) != 0) {
                        ATK.atk_state_set_add_state(l3, 21);
                    }
                    if ((n2 & 0x20000) != 0) {
                        ATK.atk_state_set_add_state(l3, 19);
                    }
                    if ((n2 & 1) == 0) {
                        ATK.atk_state_set_add_state(l3, 7);
                    }
                    if ((n2 & 0x4000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 1);
                    }
                    if ((n2 & 0x8000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 24);
                    }
                    if ((n2 & 0x10000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 15);
                    }
                    if ((n2 & 0x2000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 32);
                    }
                    if ((n2 & 0x20000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 33);
                    }
                    if ((n2 & 0x40000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 34);
                    }
                }
                return l3;
            }
        }
        return l2;
    }

    static AtkSelectionIface getSelectionIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_SELECTION())) {
            AtkSelectionIface atkSelectionIface = new AtkSelectionIface();
            ATK.memmove(atkSelectionIface, ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(l)));
            return atkSelectionIface;
        }
        return null;
    }

    static long atkSelection_is_child_selected(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_is_child_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkSelectionIface atkSelectionIface = AccessibleObject.getSelectionIface(l);
        if (atkSelectionIface != null && atkSelectionIface.is_child_selected != 0L) {
            l3 = ATK.call(atkSelectionIface.is_child_selected, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Object object;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                for (int i = 0; i < n; ++i) {
                    object = list.get(i);
                    object.getSelection(accessibleControlEvent);
                }
                Accessible accessible2 = accessibleControlEvent.accessible;
                Object object2 = object = accessible2 != null ? accessible2.getAccessibleObject() : accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (object != null) {
                    return (long)((AccessibleObject)object).index == l2 ? 1L : 0L;
                }
            }
        }
        return l3;
    }

    static long atkSelection_ref_selection(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_ref_selection");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkSelectionIface atkSelectionIface = AccessibleObject.getSelectionIface(l);
        if (atkSelectionIface != null && atkSelectionIface.ref_selection != 0L) {
            l3 = ATK.call(atkSelectionIface.ref_selection, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleControlListener> list = accessible.accessibleControlListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                for (int i = 0; i < n; ++i) {
                    AccessibleControlListener accessibleControlListener = list.get(i);
                    accessibleControlListener.getSelection(accessibleControlEvent);
                }
                AccessibleObject accessibleObject2 = accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (accessibleObject2 != null) {
                    if (l3 != 0L) {
                        OS.g_object_unref(l3);
                    }
                    OS.g_object_ref(accessibleObject2.handle);
                    return accessibleObject2.handle;
                }
            }
        }
        return l3;
    }

    static AtkTableIface getTableIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_TABLE())) {
            AtkTableIface atkTableIface = new AtkTableIface();
            ATK.memmove(atkTableIface, ATK.g_type_interface_peek_parent(ATK.ATK_TABLE_GET_IFACE(l)));
            return atkTableIface;
        }
        return null;
    }

    static long atkTable_ref_at(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_ref_at");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                for (int i = 0; i < n; ++i) {
                    object = list.get(i);
                    object.getCell(accessibleTableEvent);
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    object = accessible2.getAccessibleObject();
                    OS.g_object_ref(((AccessibleObject)object).handle);
                    return ((AccessibleObject)object).handle;
                }
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.ref_at != 0L) {
            l4 = ATK.call(atkTableIface.ref_at, l, l2, l3);
        }
        return l4;
    }

    static long atkTable_get_index_at(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_index_at");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getCell(accessibleTableEvent);
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 == null) {
                    return -1L;
                }
                accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                }
                return l2 * (long)accessibleTableEvent.count + l3;
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_index_at != 0L) {
            l4 = ATK.call(atkTableIface.get_index_at, l, l2, l3);
        }
        return l4;
    }

    static long atkTable_get_column_at_index(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_at_index: " + l + " " + l2);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                long l3;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                }
                long l4 = l3 = accessibleTableEvent.count == 0 ? -1L : l2 % (long)accessibleTableEvent.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + l3);
                }
                return l3;
            }
        }
        long l5 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_at_index != 0L) {
            l5 = ATK.call(atkTableIface.get_column_at_index, l, l2);
        }
        return l5;
    }

    static long atkTable_get_row_at_index(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_at_index: " + l + " " + l2);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                long l3;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                }
                long l4 = l3 = accessibleTableEvent.count == 0 ? -1L : l2 / (long)accessibleTableEvent.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + l3);
                }
                return l3;
            }
        }
        long l5 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_at_index != 0L) {
            l5 = ATK.call(atkTableIface.get_row_at_index, l, l2);
        }
        return l5;
    }

    static long atkTable_get_n_columns(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_columns");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_n_columns != 0L) {
            l2 = ATK.call(atkTableIface.get_n_columns, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.count = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    l2 = accessibleTableEvent.count;
                }
            }
        }
        return l2;
    }

    static long atkTable_get_n_rows(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_rows");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_n_rows != 0L) {
            l2 = ATK.call(atkTableIface.get_n_rows, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.count = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getRowCount(accessibleTableEvent);
                    l2 = accessibleTableEvent.count;
                }
            }
        }
        return l2;
    }

    static long atkTable_get_column_extent_at(long l, long l2, long l3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_extent_at");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_extent_at != 0L) {
            l4 = ATK.call(atkTableIface.get_column_extent_at, l, l2, l3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                for (int i = 0; i < n; ++i) {
                    object = list.get(i);
                    object.getCell(accessibleTableEvent);
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n = AccessibleObject.size(object = accessible2.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(accessible2);
                    accessibleTableCellEvent.count = (int)l4;
                    for (int i = 0; i < n; ++i) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)object.get(i);
                        accessibleTableCellListener.getColumnSpan(accessibleTableCellEvent);
                    }
                    return accessibleTableCellEvent.count;
                }
            }
        }
        return l4;
    }

    static long atkTable_get_row_extent_at(long l, long l2, long l3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_extent_at");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_extent_at != 0L) {
            l4 = ATK.call(atkTableIface.get_row_extent_at, l, l2, l3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                for (int i = 0; i < n; ++i) {
                    object = list.get(i);
                    object.getCell(accessibleTableEvent);
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n = AccessibleObject.size(object = accessible2.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(accessible2);
                    accessibleTableCellEvent.count = (int)l4;
                    for (int i = 0; i < n; ++i) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)object.get(i);
                        accessibleTableCellListener.getRowSpan(accessibleTableCellEvent);
                    }
                    return accessibleTableCellEvent.count;
                }
            }
        }
        return l4;
    }

    static long atkTable_get_caption(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_caption");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getCaption(accessibleTableEvent);
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    return accessible2.getAccessibleObject().handle;
                }
            }
        }
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_caption != 0L) {
            l2 = ATK.call(atkTableIface.get_caption, l);
        }
        return l2;
    }

    static long atkTable_get_summary(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_summary");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getSummary(accessibleTableEvent);
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    return accessible2.getAccessibleObject().handle;
                }
            }
        }
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_summary != 0L) {
            l2 = ATK.call(atkTableIface.get_summary, l);
        }
        return l2;
    }

    static long atkTable_get_column_description(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_description");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_description != 0L) {
            l3 = ATK.call(atkTableIface.get_column_description, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = (int)l2;
                if (l3 != 0L) {
                    accessibleTableEvent.result = AccessibleObject.getString(l3);
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getColumnDescription(accessibleTableEvent);
                }
                if (accessibleTableEvent.result == null) {
                    return l3;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleTableEvent.result);
                return descriptionPtr;
            }
        }
        return l3;
    }

    static long atkTable_get_column_header(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_header");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getRowHeaderCells(accessibleTableEvent);
                }
                Accessible[] accessibleArray = accessibleTableEvent.accessibles;
                if (accessibleArray != null && 0L <= l2 && l2 < (long)accessibleArray.length) {
                    return accessibleArray[(int)l2].getAccessibleObject().handle;
                }
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_header != 0L) {
            l3 = ATK.call(atkTableIface.get_column_header, l, l2);
        }
        return l3;
    }

    static long atkTable_get_row_description(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_description");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_description != 0L) {
            l3 = ATK.call(atkTableIface.get_row_description, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                if (l3 != 0L) {
                    accessibleTableEvent.result = AccessibleObject.getString(l3);
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getRowDescription(accessibleTableEvent);
                }
                if (accessibleTableEvent.result == null) {
                    return l3;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleTableEvent.result);
                return descriptionPtr;
            }
        }
        return l3;
    }

    static long atkTable_get_row_header(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_header");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.getRowHeaderCells(accessibleTableEvent);
                }
                Accessible[] accessibleArray = accessibleTableEvent.accessibles;
                if (accessibleArray != null && 0L <= l2 && l2 < (long)accessibleArray.length) {
                    return accessibleArray[(int)l2].getAccessibleObject().handle;
                }
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_header != 0L) {
            l3 = ATK.call(atkTableIface.get_row_header, l, l2);
        }
        return l3;
    }

    static long atkTable_get_selected_columns(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_columns");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int n2;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (n2 = 0; n2 < n; ++n2) {
                    AccessibleTableListener accessibleTableListener = list.get(n2);
                    accessibleTableListener.getSelectedColumns(accessibleTableEvent);
                }
                n2 = accessibleTableEvent.selected != null ? accessibleTableEvent.selected.length : 0;
                long l3 = OS.g_malloc(n2 * 4);
                if (accessibleTableEvent.selected != null) {
                    OS.memmove(l3, accessibleTableEvent.selected, (long)(n2 * 4));
                }
                if (l2 != 0L) {
                    OS.memmove(l2, new long[]{l3}, (long)C.PTR_SIZEOF);
                }
                return n2;
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_selected_columns != 0L) {
            l4 = ATK.call(atkTableIface.get_selected_columns, l, l2);
        }
        return l4;
    }

    static long atkTable_get_selected_rows(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_rows");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int n2;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                for (n2 = 0; n2 < n; ++n2) {
                    AccessibleTableListener accessibleTableListener = list.get(n2);
                    accessibleTableListener.getSelectedRows(accessibleTableEvent);
                }
                n2 = accessibleTableEvent.selected != null ? accessibleTableEvent.selected.length : 0;
                long l3 = OS.g_malloc(n2 * 4);
                if (accessibleTableEvent.selected != null) {
                    OS.memmove(l3, accessibleTableEvent.selected, (long)(n2 * 4));
                }
                if (l2 != 0L) {
                    OS.memmove(l2, new long[]{l3}, (long)C.PTR_SIZEOF);
                }
                return n2;
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_selected_rows != 0L) {
            l4 = ATK.call(atkTableIface.get_selected_rows, l, l2);
        }
        return l4;
    }

    static long atkTable_is_column_selected(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_column_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.is_column_selected != 0L) {
            l3 = ATK.call(atkTableIface.is_column_selected, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.isSelected = l3 != 0L;
                accessibleTableEvent.column = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.isColumnSelected(accessibleTableEvent);
                }
                return accessibleTableEvent.isSelected ? 1L : 0L;
            }
        }
        return l3;
    }

    static long atkTable_is_row_selected(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_row_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.is_row_selected != 0L) {
            l3 = ATK.call(atkTableIface.is_row_selected, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.isSelected = l3 != 0L;
                accessibleTableEvent.row = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.isRowSelected(accessibleTableEvent);
                }
                return accessibleTableEvent.isSelected ? 1L : 0L;
            }
        }
        return l3;
    }

    static long atkTable_is_selected(long l, long l2, long l3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.is_selected != 0L) {
            l4 = ATK.call(atkTableIface.is_selected, l, l2, l3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                for (int i = 0; i < n; ++i) {
                    object = list.get(i);
                    object.getCell(accessibleTableEvent);
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n = AccessibleObject.size(object = accessible2.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(accessible2);
                    accessibleTableCellEvent.isSelected = l4 != 0L;
                    for (int i = 0; i < n; ++i) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)object.get(i);
                        accessibleTableCellListener.isSelected(accessibleTableCellEvent);
                    }
                    return accessibleTableCellEvent.isSelected ? 1L : 0L;
                }
            }
        }
        return l4;
    }

    static long atkTable_add_row_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_row_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.selectRow(accessibleTableEvent);
                }
                return "OK".equals(accessibleTableEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.add_row_selection != 0L) {
            l3 = ATK.call(atkTableIface.add_row_selection, l, l2);
        }
        return l3;
    }

    static long atkTable_remove_row_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_row_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.deselectRow(accessibleTableEvent);
                }
                return "OK".equals(accessibleTableEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.remove_row_selection != 0L) {
            l3 = ATK.call(atkTableIface.remove_row_selection, l, l2);
        }
        return l3;
    }

    static long atkTable_add_column_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_column_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.selectColumn(accessibleTableEvent);
                }
                return "OK".equals(accessibleTableEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.add_column_selection != 0L) {
            l3 = ATK.call(atkTableIface.add_column_selection, l, l2);
        }
        return l3;
    }

    static long atkTable_remove_column_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_column_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTableListener> list = accessible.accessibleTableListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTableListener accessibleTableListener = list.get(i);
                    accessibleTableListener.deselectColumn(accessibleTableEvent);
                }
                return "OK".equals(accessibleTableEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.remove_column_selection != 0L) {
            l3 = ATK.call(atkTableIface.remove_column_selection, l, l2);
        }
        return l3;
    }

    static AtkTextIface getTextIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_TEXT())) {
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(l)));
            return atkTextIface;
        }
        return null;
    }

    static long atkText_get_character_extents(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Object object2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)(l2 + 1L);
                for (int i = 0; i < n; ++i) {
                    object2 = list.get(i);
                    object2.getTextBounds(accessibleTextEvent);
                }
                int[] nArray = new int[1];
                object2 = new int[1];
                if (l7 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, (int[])object2);
                    accessibleTextEvent.x -= nArray[0];
                    accessibleTextEvent.y -= object2[0];
                }
                OS.memmove(l3, new int[]{accessibleTextEvent.x}, 4L);
                OS.memmove(l4, new int[]{accessibleTextEvent.y}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.width}, 4L);
                OS.memmove(l6, new int[]{accessibleTextEvent.height}, 4L);
                return 0L;
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_character_extents != 0L) {
            ATK.call(((AtkTextIface)object).get_character_extents, l, l2, l3, l4, l5, l6, l7);
        }
        return 0L;
    }

    static String getString(long l) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    static long getStringPtr(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string != null ? string : "", true);
        long l = OS.g_malloc(byArray.length);
        OS.memmove(l, byArray, (long)byArray.length);
        return l;
    }

    static long atkText_get_range_extents(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_range_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                Object object2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)l3;
                for (int i = 0; i < n; ++i) {
                    object2 = list.get(i);
                    object2.getTextBounds(accessibleTextEvent);
                }
                int[] nArray = new int[1];
                object2 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, (int[])object2);
                    accessibleTextEvent.x -= nArray[0];
                    accessibleTextEvent.y -= object2[0];
                }
                AtkTextRectangle atkTextRectangle = new AtkTextRectangle();
                atkTextRectangle.x = accessibleTextEvent.x;
                atkTextRectangle.y = accessibleTextEvent.y;
                atkTextRectangle.width = accessibleTextEvent.width;
                atkTextRectangle.height = accessibleTextEvent.height;
                ATK.memmove(l5, atkTextRectangle, AtkTextRectangle.sizeof);
                return 0L;
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_range_extents != 0L) {
            ATK.call(((AtkTextIface)object).get_range_extents, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static long atkText_get_run_attributes(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_run_attributes");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleAttributeListener> list = accessible.accessibleAttributeListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(accessible);
                accessibleTextAttributeEvent.offset = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleAttributeListener accessibleAttributeListener = list.get(i);
                    accessibleAttributeListener.getTextAttributes(accessibleTextAttributeEvent);
                }
                OS.memmove(l3, new int[]{accessibleTextAttributeEvent.start}, 4L);
                OS.memmove(l4, new int[]{accessibleTextAttributeEvent.end}, 4L);
                TextStyle textStyle = accessibleTextAttributeEvent.textStyle;
                long l5 = 0L;
                AtkAttribute atkAttribute = new AtkAttribute();
                if (textStyle != null) {
                    Color color;
                    Font font;
                    long l6;
                    if (textStyle.rise != 0) {
                        l6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(10));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(textStyle.rise));
                        ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l6);
                    }
                    if (textStyle.underline) {
                        l6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(11));
                        String string = "none";
                        switch (textStyle.underlineStyle) {
                            case 1: {
                                string = "double";
                                break;
                            }
                            case 0: {
                                string = "single";
                                break;
                            }
                            case 2: {
                                string = "error";
                                break;
                            }
                            case 3: {
                                string = "squiggle";
                            }
                        }
                        atkAttribute.value = AccessibleObject.getStringPtr(string);
                        ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l6);
                    }
                    if (textStyle.strikeout) {
                        l6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(12));
                        atkAttribute.value = AccessibleObject.getStringPtr("1");
                        ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l6);
                    }
                    if ((font = textStyle.font) != null && !font.isDisposed()) {
                        long l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(17));
                        atkAttribute.value = ATK.g_strdup(OS.pango_font_description_get_family(font.handle));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(13));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_size(font.handle) / 1024));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(27));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(27, OS.pango_font_description_get_style(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(26));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(26, OS.pango_font_description_get_variant(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(25));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(25, OS.pango_font_description_get_stretch(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(15));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_weight(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                    }
                    if ((color = textStyle.foreground) != null && !color.isDisposed()) {
                        long l8 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(19));
                        atkAttribute.value = AccessibleObject.getStringPtr((color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(l8, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l8);
                    }
                    if ((color = textStyle.background) != null && !color.isDisposed()) {
                        long l9 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(18));
                        atkAttribute.value = AccessibleObject.getStringPtr((color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(l9, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l9);
                    }
                }
                if (accessibleTextAttributeEvent.attributes != null) {
                    int n2 = accessibleTextAttributeEvent.attributes.length / 2 * 2;
                    for (int i = 0; i < n2; i += 2) {
                        long l10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = AccessibleObject.getStringPtr(accessibleTextAttributeEvent.attributes[i]);
                        atkAttribute.value = AccessibleObject.getStringPtr(accessibleTextAttributeEvent.attributes[i + 1]);
                        ATK.memmove(l10, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l10);
                    }
                }
                return l5;
            }
        }
        long l11 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_run_attributes != 0L) {
            l11 = ATK.call(atkTextIface.get_run_attributes, l, l2, l3, l4);
        }
        return l11;
    }

    static long atkText_get_offset_at_point(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_offset_at_point");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.x = (int)l2;
                accessibleTextEvent.y = (int)l3;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, nArray2);
                    accessibleTextEvent.x += nArray[0];
                    accessibleTextEvent.y += nArray2[0];
                }
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getOffsetAtPoint(accessibleTextEvent);
                }
                return accessibleTextEvent.offset;
            }
        }
        long l5 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_offset_at_point != 0L) {
            l5 = ATK.call(atkTextIface.get_offset_at_point, l, l2, l3, l4);
        }
        return l5;
    }

    static long atkText_add_selection(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_add_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)l3;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.addSelection(accessibleTextEvent);
                }
                return "OK".equals(accessibleTextEvent.result) ? 1L : 0L;
            }
        }
        long l4 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.add_selection != 0L) {
            l4 = ATK.call(atkTextIface.add_selection, l, l2, l3);
        }
        return l4;
    }

    static long atkText_remove_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_remove_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.removeSelection(accessibleTextEvent);
                }
                return "OK".equals(accessibleTextEvent.result) ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.remove_selection != 0L) {
            l3 = ATK.call(atkTextIface.remove_selection, l, l2);
        }
        return l3;
    }

    static long atkText_set_caret_offset(long l, long l2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_caret_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.offset = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.setCaretOffset(accessibleTextEvent);
                }
                return "OK".equals(accessibleTextEvent.result) ? 1L : 0L;
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).set_caret_offset != 0L) {
            return ATK.call(((AtkTextIface)object).set_caret_offset, l, l2);
        }
        return 0L;
    }

    static long atkText_set_selection(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                accessibleTextEvent.start = (int)l3;
                accessibleTextEvent.end = (int)l4;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.setSelection(accessibleTextEvent);
                }
                return "OK".equals(accessibleTextEvent.result) ? 1L : 0L;
            }
        }
        long l5 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.set_selection != 0L) {
            l5 = ATK.call(atkTextIface.set_selection, l, l2, l3, l4);
        }
        return l5;
    }

    static long atkText_get_caret_offset(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_caret_offset");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_caret_offset != 0L) {
            l2 = ATK.call(atkTextIface.get_caret_offset, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getCaretOffset(accessibleTextEvent);
                }
                return accessibleTextEvent.offset;
            }
            List<AccessibleTextListener> list2 = accessible.accessibleTextListeners;
            n = AccessibleObject.size(list2);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject.accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                accessibleTextEvent.offset = (int)l2;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextListener accessibleTextListener = list2.get(i);
                    accessibleTextListener.getCaretOffset(accessibleTextEvent);
                }
                return accessibleTextEvent.offset;
            }
        }
        return l2;
    }

    static long atkText_get_bounded_ranges(long l, long l2, long l3, long l4, long l5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_bounded_ranges");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int n2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                AtkTextRectangle atkTextRectangle = new AtkTextRectangle();
                ATK.memmove(atkTextRectangle, l2, AtkTextRectangle.sizeof);
                accessibleTextEvent.x = atkTextRectangle.x;
                accessibleTextEvent.y = atkTextRectangle.y;
                accessibleTextEvent.width = atkTextRectangle.width;
                accessibleTextEvent.height = atkTextRectangle.height;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getRanges(accessibleTextEvent);
                }
                int[] nArray = accessibleTextEvent.ranges;
                int n3 = nArray == null ? 1 : nArray.length / 2;
                long l6 = OS.malloc(n3 * AtkTextRange.sizeof);
                AtkTextRange atkTextRange = new AtkTextRange();
                int n4 = n2 = nArray != null ? nArray.length / 2 : 1;
                for (int i = 0; i < n2; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    int n5;
                    if (nArray != null) {
                        n5 = i * 2;
                        accessibleTextEvent.start = nArray[n5];
                        accessibleTextEvent.end = nArray[n5 + 1];
                    }
                    accessibleTextEvent.count = 0;
                    accessibleTextEvent.type = 5;
                    for (n5 = 0; n5 < n; ++n5) {
                        accessibleTextExtendedListener = list.get(n5);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                    }
                    atkTextRange.start_offset = accessibleTextEvent.start;
                    atkTextRange.end_offset = accessibleTextEvent.end;
                    atkTextRange.content = AccessibleObject.getStringPtr(accessibleTextEvent.result);
                    accessibleTextEvent.result = null;
                    accessibleTextEvent.height = 0;
                    accessibleTextEvent.width = 0;
                    accessibleTextEvent.y = 0;
                    accessibleTextEvent.x = 0;
                    accessibleTextEvent.type = 0;
                    accessibleTextEvent.count = 0;
                    for (n5 = 0; n5 < n; ++n5) {
                        accessibleTextExtendedListener = list.get(n5);
                        accessibleTextExtendedListener.getTextBounds(accessibleTextEvent);
                    }
                    atkTextRange.bounds.x = accessibleTextEvent.x;
                    atkTextRange.bounds.y = accessibleTextEvent.y;
                    atkTextRange.bounds.width = accessibleTextEvent.width;
                    atkTextRange.bounds.height = accessibleTextEvent.height;
                    ATK.memmove(l6 + (long)(i * AtkTextRange.sizeof), atkTextRange, AtkTextRange.sizeof);
                }
                return l6;
            }
        }
        long l7 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_bounded_ranges != 0L) {
            l7 = ATK.call(atkTextIface.get_bounded_ranges, l);
        }
        return l7;
    }

    static long atkText_get_character_at_offset(long l, long l2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_at_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)(l2 + 1L);
                accessibleTextEvent.type = 0;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                }
                String string = accessibleTextEvent.result;
                return string != null && string.length() > 0 ? (long)string.charAt(0) : 0L;
            }
            String string = accessibleObject.getText();
            if (string != null && (long)string.length() > l2) {
                return string.charAt((int)l2);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_character_at_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_character_at_offset, l, l2);
        }
        return 0L;
    }

    static long atkText_get_character_count(long l) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_count");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getCharacterCount(accessibleTextEvent);
                }
                return accessibleTextEvent.count;
            }
            String string = accessibleObject.getText();
            if (string != null) {
                return string.length();
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_character_count != 0L) {
            return ATK.call(((AtkTextIface)object).get_character_count, l);
        }
        return 0L;
    }

    static long atkText_get_n_selections(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_n_selections");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getSelectionCount(accessibleTextEvent);
                }
                return accessibleTextEvent.count;
            }
            List<AccessibleTextListener> list2 = accessible.accessibleTextListeners;
            n = AccessibleObject.size(list2);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject.accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextListener accessibleTextListener = list2.get(i);
                    accessibleTextListener.getSelectionRange(accessibleTextEvent);
                }
                if (accessibleTextEvent.length > 0) {
                    return 1L;
                }
            }
        }
        long l2 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_n_selections != 0L) {
            l2 = ATK.call(atkTextIface.get_n_selections, l);
        }
        return l2;
    }

    static long atkText_get_selection(long l, long l2, long l3, long l4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_selection");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l5 = 0L;
        OS.memmove(l3, new int[]{0}, 4L);
        OS.memmove(l4, new int[]{0}, 4L);
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_selection != 0L) {
            l5 = ATK.call(atkTextIface.get_selection, l, l2, l3, l4);
        }
        if (accessibleObject != null) {
            List<AccessibleTextListener> list;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.memmove(nArray, l3, 4L);
            OS.memmove(nArray2, l4, 4L);
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list2 = accessible.accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list2);
            if (n > 0) {
                AccessibleTextExtendedListener accessibleTextExtendedListener;
                int n2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                accessibleTextEvent.start = nArray[0];
                accessibleTextEvent.end = nArray2[0];
                for (n2 = 0; n2 < n; ++n2) {
                    accessibleTextExtendedListener = list2.get(n2);
                    accessibleTextExtendedListener.getSelection(accessibleTextEvent);
                }
                nArray[0] = accessibleTextEvent.start;
                nArray2[0] = accessibleTextEvent.end;
                OS.memmove(l3, nArray, 4L);
                OS.memmove(l4, nArray2, 4L);
                accessibleTextEvent.index = 0;
                accessibleTextEvent.count = 0;
                accessibleTextEvent.type = 5;
                for (n2 = 0; n2 < n; ++n2) {
                    accessibleTextExtendedListener = list2.get(n2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                }
                if (l5 != 0L) {
                    OS.g_free(l5);
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            if (l2 == 0L && (n = AccessibleObject.size(list = accessible.accessibleTextListeners)) > 0) {
                String string;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                accessibleTextEvent.offset = nArray[0];
                accessibleTextEvent.length = nArray2[0] - nArray[0];
                for (int i = 0; i < n; ++i) {
                    AccessibleTextListener accessibleTextListener = list.get(i);
                    accessibleTextListener.getSelectionRange(accessibleTextEvent);
                }
                OS.memmove(l3, new int[]{accessibleTextEvent.offset}, 4L);
                OS.memmove(l4, new int[]{accessibleTextEvent.offset + accessibleTextEvent.length}, 4L);
                if (l5 != 0L) {
                    OS.g_free(l5);
                }
                if ((string = accessibleObject.getText()) != null && string.length() > accessibleTextEvent.offset && string.length() >= accessibleTextEvent.offset + accessibleTextEvent.length) {
                    return AccessibleObject.getStringPtr(string.substring(accessibleTextEvent.offset, accessibleTextEvent.offset + accessibleTextEvent.length));
                }
                if (atkTextIface != null && atkTextIface.get_text != 0L) {
                    return ATK.call(atkTextIface.get_text, l, accessibleTextEvent.offset, accessibleTextEvent.offset + accessibleTextEvent.length);
                }
                return 0L;
            }
        }
        return l5;
    }

    static long atkText_get_text(long l, long l2, long l3) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text: " + l + " " + l2 + "," + l3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)l3;
                accessibleTextEvent.type = 5;
                for (int i = 0; i < n; ++i) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(i);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                l3 = l3 == -1L ? (long)string.length() : Math.min(l3, (long)string.length());
                l2 = Math.min(l2, l3);
                string = string.substring((int)l2, (int)l3);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text != 0L) {
            return ATK.call(((AtkTextIface)object).get_text, l, l2, l3);
        }
        return 0L;
    }

    static long atkText_get_text_after_offset(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_after_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int n2;
                long l6 = AccessibleObject.atkText_get_character_count(l);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = (int)l2;
                accessibleTextEvent.count = 1;
                switch ((int)l3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n3 = accessibleTextEvent.start;
                int n4 = accessibleTextEvent.end;
                for (n2 = 0; n2 < n; ++n2) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(n2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                }
                switch ((int)l3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        int n5;
                        if ((long)accessibleTextEvent.end >= l6) break;
                        n2 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n3;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.count = 2;
                        for (n5 = 0; n5 < n; ++n5) {
                            accessibleTextExtendedListener = list.get(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        for (n5 = 0; n5 < n; ++n5) {
                            accessibleTextExtendedListener = list.get(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        int n6;
                        if (0 >= accessibleTextEvent.start) break;
                        n2 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n3;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.count = 0;
                        for (n6 = 0; n6 < n; ++n6) {
                            accessibleTextExtendedListener = list.get(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n2;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        for (n6 = 0; n6 < n; ++n6) {
                            accessibleTextExtendedListener = list.get(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        break;
                    }
                }
                OS.memmove(l4, new int[]{accessibleTextEvent.start}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.end}, 4L);
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n7 = (int)l2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n = string.length();
                int n8 = n7 = Math.min(n7, n - 1);
                int n9 = n7;
                switch ((int)l3) {
                    case 0: {
                        if (n <= n7) break;
                        break;
                    }
                    case 1: {
                        int n10 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n7 - 1);
                        if (n10 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n10 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n10)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n10;
                        int n11 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n10);
                        if (n11 == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n11);
                        break;
                    }
                    case 2: {
                        int n12 = AccessibleObject.previousIndexOfNotChar(string, " \n", n7);
                        if (n12 == -1 || n12 != n7 - 1) {
                            n7 = AccessibleObject.nextIndexOfNotChar(string, " \n", n7);
                        }
                        if (n7 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        int n13 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n7);
                        if (n13 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n13 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n13)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n13;
                        int n14 = AccessibleObject.nextIndexOfNotChar(string, " \n", n13);
                        if (n14 == n) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n14 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n14)) == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n14);
                        break;
                    }
                    case 3: {
                        int n15 = AccessibleObject.previousIndexOfChar(string, "!?.", n7);
                        int n16 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n7);
                        int n17 = 0;
                        if (n15 >= n16) {
                            n17 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n7);
                        } else {
                            n17 = AccessibleObject.nextIndexOfChar(string, "!?.", n7);
                            if (n17 == -1) {
                                n8 = n9 = n;
                                break;
                            }
                            n17 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n17);
                        }
                        if (n17 == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n17;
                        int n18 = AccessibleObject.nextIndexOfChar(string, "!?.", n17);
                        if (n18 == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n18);
                        break;
                    }
                    case 4: {
                        int n19 = AccessibleObject.nextIndexOfChar(string, "!?.", n7);
                        if (n19 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n19 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n19)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n19;
                        int n20 = AccessibleObject.nextIndexOfNotChar(string, " \n", n19);
                        if (n20 == n) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n20 = AccessibleObject.nextIndexOfChar(string, "!?.", n20)) == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n20);
                        break;
                    }
                    case 5: {
                        int n21 = string.indexOf(10, n7 - 1);
                        if (n21 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n21 = AccessibleObject.nextIndexOfNotChar(string, "\n", n21)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n21;
                        int n22 = string.indexOf(10, n21);
                        if (n22 == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = n22 = AccessibleObject.nextIndexOfNotChar(string, "\n", n22);
                        break;
                    }
                    case 6: {
                        int n23 = AccessibleObject.nextIndexOfChar(string, "\n", n7);
                        if (n23 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n23;
                        if (n8 == n) {
                            n9 = n;
                            break;
                        }
                        int n24 = AccessibleObject.nextIndexOfChar(string, "\n", n23 + 1);
                        if (n24 == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = n24;
                        break;
                    }
                }
                OS.memmove(l4, new int[]{n8}, 4L);
                OS.memmove(l5, new int[]{++n9}, 4L);
                string = string.substring(n8, n9);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text_after_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_text_after_offset, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static long atkText_get_text_at_offset(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_at_offset: " + l2 + " start: " + l4 + " end: " + l5);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int n2;
                long l6 = AccessibleObject.atkText_get_character_count(l);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = (int)l2;
                accessibleTextEvent.count = 0;
                switch ((int)l3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n3 = accessibleTextEvent.start;
                int n4 = accessibleTextEvent.end;
                for (n2 = 0; n2 < n; ++n2) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(n2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                }
                switch ((int)l3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        int n5;
                        if ((long)accessibleTextEvent.end >= l6) break;
                        n2 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n3;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.count = 1;
                        for (n5 = 0; n5 < n; ++n5) {
                            accessibleTextExtendedListener = list.get(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        for (n5 = 0; n5 < n; ++n5) {
                            accessibleTextExtendedListener = list.get(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        int n6;
                        if (0 >= accessibleTextEvent.start) break;
                        n2 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n3;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.count = -1;
                        for (n6 = 0; n6 < n; ++n6) {
                            accessibleTextExtendedListener = list.get(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n2;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        for (n6 = 0; n6 < n; ++n6) {
                            accessibleTextExtendedListener = list.get(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        break;
                    }
                }
                OS.memmove(l4, new int[]{accessibleTextEvent.start}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.end}, 4L);
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n7 = (int)l2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n = string.length();
                int n8 = n7 = Math.min(n7, n - 1);
                int n9 = n7;
                switch ((int)l3) {
                    case 0: {
                        if (n <= n7) break;
                        break;
                    }
                    case 1: {
                        int n10 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n7);
                        if (n10 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        if ((n10 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n10) + 1) == -1) {
                            n8 = 0;
                            break;
                        }
                        n8 = n10;
                        int n11 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n10);
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n11);
                        break;
                    }
                    case 2: {
                        int n12 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n7 + 1);
                        n12 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n12);
                        n12 = AccessibleObject.previousIndexOfNotChar(string, " \n", n12 + 1);
                        if (n12 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n8 = n12 + 1;
                        int n13 = AccessibleObject.nextIndexOfNotChar(string, " \n", n8);
                        if (n13 == n) {
                            n9 = n8;
                            break;
                        }
                        if ((n13 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n13)) == -1) {
                            n9 = n8;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n13);
                        break;
                    }
                    case 3: {
                        int n14 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n7 + 1);
                        if (n14 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n14 = AccessibleObject.previousIndexOfChar(string, "!?.", n14) + 1;
                        n8 = AccessibleObject.nextIndexOfNotChar(string, " \n", n14);
                        int n15 = AccessibleObject.nextIndexOfChar(string, "!?.", n8);
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n15);
                        break;
                    }
                    case 4: {
                        int n16 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n7 + 1);
                        n16 = AccessibleObject.previousIndexOfChar(string, "!?.", n16);
                        n16 = AccessibleObject.previousIndexOfNotChar(string, " \n", n16 + 1);
                        if (n16 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n8 = n16 + 1;
                        int n17 = AccessibleObject.nextIndexOfNotChar(string, " \n", n8);
                        if (n17 == n) {
                            n9 = n8;
                            break;
                        }
                        if ((n17 = AccessibleObject.nextIndexOfChar(string, "!?.", n17)) == -1) {
                            n9 = n8;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n17);
                        break;
                    }
                    case 5: {
                        n8 = AccessibleObject.previousIndexOfChar(string, "\n", n7) + 1;
                        int n18 = AccessibleObject.nextIndexOfChar(string, "\n", n8);
                        if (n18 < n) {
                            ++n18;
                        }
                        n9 = n18;
                        break;
                    }
                    case 6: {
                        int n19 = AccessibleObject.previousIndexOfChar(string, "\n", n7);
                        if (n19 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n8 = n19;
                        n9 = AccessibleObject.nextIndexOfChar(string, "\n", n19 + 1);
                    }
                }
                OS.memmove(l4, new int[]{n8}, 4L);
                OS.memmove(l5, new int[]{++n9}, 4L);
                string = string.substring(n8, n9);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text_at_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_text_at_offset, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static long atkText_get_text_before_offset(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_before_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            List<AccessibleTextExtendedListener> list = ((Accessible)object).accessibleTextExtendedListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                int n2;
                long l6 = AccessibleObject.atkText_get_character_count(l);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = (int)l2;
                accessibleTextEvent.count = -1;
                switch ((int)l3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n3 = accessibleTextEvent.start;
                int n4 = accessibleTextEvent.end;
                for (n2 = 0; n2 < n; ++n2) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = list.get(n2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                }
                OS.memmove(l4, new int[]{accessibleTextEvent.start}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.end}, 4L);
                switch ((int)l3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        int n5;
                        if ((long)accessibleTextEvent.end >= l6) break;
                        n2 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n3;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.count = 0;
                        for (n5 = 0; n5 < n; ++n5) {
                            accessibleTextExtendedListener = list.get(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        for (n5 = 0; n5 < n; ++n5) {
                            accessibleTextExtendedListener = list.get(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        int n6;
                        if (0 >= accessibleTextEvent.start) break;
                        n2 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n3;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.count = -2;
                        for (n6 = 0; n6 < n; ++n6) {
                            accessibleTextExtendedListener = list.get(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n2;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        for (n6 = 0; n6 < n; ++n6) {
                            accessibleTextExtendedListener = list.get(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                        }
                        break;
                    }
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n7 = (int)l2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n = string.length();
                int n8 = n7 = Math.min(n7, n - 1);
                int n9 = n7;
                switch ((int)l3) {
                    case 0: {
                        if (n < n7 || n7 <= 0) break;
                        break;
                    }
                    case 1: {
                        int n10 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n7 - 1);
                        if (n10 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        int n11 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n10);
                        if (n11 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n10 + 1;
                        n8 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n11) + 1;
                        break;
                    }
                    case 2: {
                        int n12 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n7);
                        if (n12 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        if ((n12 = AccessibleObject.previousIndexOfNotChar(string, " \n", n12 + 1)) == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n12 + 1;
                        int n13 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n9);
                        if ((n13 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n13)) == -1) {
                            n8 = 0;
                            break;
                        }
                        n8 = AccessibleObject.previousIndexOfNotChar(string, " \n", n13 + 1) + 1;
                        break;
                    }
                    case 3: {
                        int n14 = AccessibleObject.previousIndexOfChar(string, "!?.", n7);
                        if (n14 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        int n15 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n14);
                        if (n15 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n14 + 1;
                        n8 = AccessibleObject.previousIndexOfChar(string, "!?.", n15) + 1;
                        break;
                    }
                    case 4: {
                        int n16 = AccessibleObject.previousIndexOfChar(string, "!?.", n7);
                        if (n16 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        if ((n16 = AccessibleObject.previousIndexOfNotChar(string, " \n", n16 + 1)) == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n16 + 1;
                        int n17 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n9);
                        if ((n17 = AccessibleObject.previousIndexOfChar(string, "!?.", n17)) == -1) {
                            n8 = 0;
                            break;
                        }
                        n8 = AccessibleObject.previousIndexOfNotChar(string, " \n", n17 + 1) + 1;
                        break;
                    }
                    case 5: {
                        int n18 = AccessibleObject.previousIndexOfChar(string, "\n", n7);
                        if (n18 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n18 + 1;
                        n8 = AccessibleObject.previousIndexOfChar(string, "\n", n18) + 1;
                        break;
                    }
                    case 6: {
                        int n19 = AccessibleObject.previousIndexOfChar(string, "\n", n7);
                        if (n19 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n19;
                        n8 = AccessibleObject.previousIndexOfChar(string, "\n", n19);
                        if (n8 != -1) break;
                        n8 = 0;
                        break;
                    }
                }
                OS.memmove(l4, new int[]{--n8}, 4L);
                OS.memmove(l5, new int[]{n9}, 4L);
                string = string.substring(n8, n9);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text_before_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_text_before_offset, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static void setGValue(long l, Number number) {
        if (number == null) {
            return;
        }
        if (OS.G_VALUE_TYPE(l) != 0L) {
            OS.g_value_unset(l);
        }
        if (number instanceof Double) {
            OS.g_value_init(l, OS.G_TYPE_DOUBLE());
            OS.g_value_set_double(l, number.doubleValue());
        } else if (number instanceof Float) {
            OS.g_value_init(l, OS.G_TYPE_FLOAT());
            OS.g_value_set_float(l, number.floatValue());
        } else if (number instanceof Long) {
            OS.g_value_init(l, OS.G_TYPE_INT64());
            OS.g_value_set_int64(l, number.longValue());
        } else {
            OS.g_value_init(l, OS.G_TYPE_INT());
            OS.g_value_set_int(l, number.intValue());
        }
    }

    static Number getGValue(long l) {
        long l2 = OS.G_VALUE_TYPE(l);
        if (l2 == 0L) {
            return null;
        }
        if (l2 == OS.G_TYPE_DOUBLE()) {
            return new Double(OS.g_value_get_double(l));
        }
        if (l2 == OS.G_TYPE_FLOAT()) {
            return new Float(OS.g_value_get_float(l));
        }
        if (l2 == OS.G_TYPE_INT64()) {
            return new Long(OS.g_value_get_int64(l));
        }
        return OS.g_value_get_int(l);
    }

    static AtkValueIface getValueIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_VALUE())) {
            AtkValueIface atkValueIface = new AtkValueIface();
            ATK.memmove(atkValueIface, ATK.g_type_interface_peek_parent(ATK.ATK_VALUE_GET_IFACE(l)));
            return atkValueIface;
        }
        return null;
    }

    static long atkValue_get_current_value(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_current_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.get_current_value != 0L) {
            ATK.call(atkValueIface.get_current_value, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleValueListener> list = accessible.accessibleValueListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                for (int i = 0; i < n; ++i) {
                    AccessibleValueListener accessibleValueListener = list.get(i);
                    accessibleValueListener.getCurrentValue(accessibleValueEvent);
                }
                AccessibleObject.setGValue(l2, accessibleValueEvent.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_maximum_value(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_maximum_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.get_maximum_value != 0L) {
            ATK.call(atkValueIface.get_maximum_value, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleValueListener> list = accessible.accessibleValueListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                for (int i = 0; i < n; ++i) {
                    AccessibleValueListener accessibleValueListener = list.get(i);
                    accessibleValueListener.getMaximumValue(accessibleValueEvent);
                }
                AccessibleObject.setGValue(l2, accessibleValueEvent.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_minimum_value(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_minimum_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.get_minimum_value != 0L) {
            ATK.call(atkValueIface.get_minimum_value, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleValueListener> list = accessible.accessibleValueListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                for (int i = 0; i < n; ++i) {
                    AccessibleValueListener accessibleValueListener = list.get(i);
                    accessibleValueListener.getMinimumValue(accessibleValueEvent);
                }
                AccessibleObject.setGValue(l2, accessibleValueEvent.value);
            }
        }
        return 0L;
    }

    static long atkValue_set_current_value(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_set_current_value");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            List<AccessibleValueListener> list = accessible.accessibleValueListeners;
            int n = AccessibleObject.size(list);
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                for (int i = 0; i < n; ++i) {
                    AccessibleValueListener accessibleValueListener = list.get(i);
                    accessibleValueListener.setCurrentValue(accessibleValueEvent);
                }
                return accessibleValueEvent.value != null ? 1L : 0L;
            }
        }
        long l3 = 0L;
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.set_current_value != 0L) {
            l3 = ATK.call(atkValueIface.set_current_value, l, l2);
        }
        return l3;
    }

    static AccessibleObject getAccessibleObject(long l) {
        AccessibleObject accessibleObject = AccessibleObjects.get(new LONG(l));
        if (accessibleObject == null) {
            return null;
        }
        if (accessibleObject.accessible == null) {
            return null;
        }
        Control control = accessibleObject.accessible.control;
        if (control == null || control.isDisposed()) {
            return null;
        }
        return accessibleObject;
    }

    AccessibleObject getChildByID(int n) {
        if (n == -1) {
            return this;
        }
        if (n == -2 || n == -3) {
            return null;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                AccessibleObject accessibleObject = this.children[i];
                if (accessibleObject == null || accessibleObject.id != n) continue;
                return accessibleObject;
            }
        }
        return null;
    }

    AccessibleObject getChildByIndex(int n) {
        if (this.children != null && n < this.children.length) {
            return this.children[n];
        }
        return null;
    }

    String getText() {
        List<AccessibleControlListener> list = this.accessible.accessibleControlListeners;
        int n = AccessibleObject.size(list);
        if (n > 0) {
            long l;
            long l2;
            String string = "";
            AtkTextIface atkTextIface = AccessibleObject.getTextIface(this.handle);
            if (atkTextIface != null && atkTextIface.get_character_count != 0L && (l2 = ATK.call(atkTextIface.get_character_count, this.handle)) > 0L && atkTextIface.get_text != 0L && (l = ATK.call(atkTextIface.get_text, this.handle, 0L, l2)) != 0L) {
                string = AccessibleObject.getString(l);
                OS.g_free(l);
            }
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
            accessibleControlEvent.childID = this.id;
            accessibleControlEvent.result = string;
            for (int i = 0; i < n; ++i) {
                AccessibleControlListener accessibleControlListener = list.get(i);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            return accessibleControlEvent.result;
        }
        return null;
    }

    static long gObjectClass_finalize(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->gObjectClass_finalize: " + l);
        }
        long l2 = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(l));
        long l3 = ATK.G_OBJECT_CLASS(l2);
        GObjectClass gObjectClass = new GObjectClass();
        ATK.memmove(gObjectClass, l3);
        ATK.call(gObjectClass.finalize, l);
        AccessibleObject accessibleObject = AccessibleObjects.get(new LONG(l));
        if (accessibleObject != null) {
            AccessibleObjects.remove(new LONG(l));
        }
        return 0L;
    }

    static int toATKRelation(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 9;
            }
        }
        return 0;
    }

    static void windowPoint(AccessibleObject accessibleObject, int[] nArray, int[] nArray2) {
        GtkAccessible gtkAccessible;
        long l;
        if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
            l = OS.gtk_accessible_get_widget(accessibleObject.handle);
        } else {
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, accessibleObject.handle);
            l = gtkAccessible.widget;
        }
        while (l == 0L && accessibleObject.parent != null) {
            accessibleObject = accessibleObject.parent;
            if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
                l = OS.gtk_accessible_get_widget(accessibleObject.handle);
                continue;
            }
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, accessibleObject.handle);
            l = gtkAccessible.widget;
        }
        if (l == 0L) {
            return;
        }
        long l2 = ATK.gtk_widget_get_toplevel(l);
        long l3 = OS.gtk_widget_get_window(l2);
        OS.gdk_window_get_origin(l3, nArray, nArray2);
    }

    static int nextIndexOfChar(String string, String string2, int n) {
        int n2 = string.length();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n3 = string.indexOf(c, n);
            if (n3 == -1) continue;
            n2 = Math.min(n2, n3);
        }
        return n2;
    }

    static int nextIndexOfNotChar(String string, String string2, int n) {
        char c;
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && string2.indexOf(c = string.charAt(n2)) != -1; ++n2) {
        }
        return n2;
    }

    static int previousIndexOfChar(String string, String string2, int n) {
        int n2 = -1;
        if (n < 0) {
            return n2;
        }
        string = string.substring(0, n);
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n3 = string.lastIndexOf(c);
            if (n3 == -1) continue;
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    static int previousIndexOfNotChar(String string, String string2, int n) {
        char c;
        int n2;
        if (n < 0) {
            return -1;
        }
        for (n2 = n - 1; n2 >= 0 && string2.indexOf(c = string.charAt(n2)) != -1; --n2) {
        }
        return n2;
    }

    void addRelation(int n, Accessible accessible) {
        OS.atk_object_add_relationship(this.handle, AccessibleObject.toATKRelation(n), accessible.getAccessibleObject().handle);
    }

    void release() {
        if (DEBUG) {
            AccessibleObject.print("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                AccessibleObject accessibleObject = this.children[i];
                if (accessibleObject == null) continue;
                OS.g_object_unref(accessibleObject.handle);
            }
            this.children = null;
        }
        if (this.isLightweight) {
            OS.g_object_unref(this.handle);
        }
    }

    void removeRelation(int n, Accessible accessible) {
        OS.atk_object_remove_relationship(this.handle, AccessibleObject.toATKRelation(n), accessible.getAccessibleObject().handle);
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void sendEvent(int n, Object object) {
        switch (n) {
            case 32777: {
                OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
                break;
            }
            case 32788: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
                break;
            }
            case 32778: {
                if (!(object instanceof int[])) break;
                int[] nArray = (int[])object;
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = -1;
                switch (n2) {
                    case 2: {
                        n4 = 21;
                        break;
                    }
                    case 0x200000: {
                        n4 = 20;
                        break;
                    }
                    case 0x1000000: {
                        n4 = 16;
                        break;
                    }
                    case 4: {
                        n4 = 11;
                        break;
                    }
                    case 0x100000: {
                        n4 = 10;
                        break;
                    }
                    case 8: {
                        n4 = 18;
                        break;
                    }
                    case 16: {
                        n4 = 4;
                        break;
                    }
                    case 512: {
                        n4 = 9;
                        break;
                    }
                    case 1024: {
                        n4 = 9;
                        break;
                    }
                    case 128: {
                        n4 = 2;
                        break;
                    }
                    case 2048: {
                        n4 = 3;
                        break;
                    }
                    case 64: {
                        n4 = 6;
                        break;
                    }
                    case 32768: {
                        n4 = 28;
                        break;
                    }
                    case 65536: {
                        n4 = 23;
                        break;
                    }
                    case 131072: {
                        n4 = 19;
                        break;
                    }
                    case 0x400000: {
                        break;
                    }
                    case 1: {
                        n4 = 7;
                        break;
                    }
                    case 0x4000000: {
                        n4 = 1;
                        break;
                    }
                    case 0x8000000: {
                        n4 = 24;
                        break;
                    }
                    case 0x10000000: {
                        n4 = 15;
                        break;
                    }
                    case 0x2000000: {
                        n4 = 32;
                        break;
                    }
                    case 0x20000000: {
                        n4 = 33;
                        break;
                    }
                    case 0x40000000: {
                        n4 = 34;
                    }
                }
                if (n4 == -1) break;
                ATK.atk_object_notify_state_change(this.handle, n4, n3 != 0);
                break;
            }
            case 32779: {
                List<AccessibleControlListener> list = this.accessible.accessibleControlListeners;
                int n5 = AccessibleObject.size(list);
                GdkRectangle gdkRectangle = new GdkRectangle();
                if (n5 > 0) {
                    AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
                    accessibleControlEvent.childID = this.id;
                    for (int i = 0; i < n5; ++i) {
                        AccessibleControlListener accessibleControlListener = list.get(i);
                        accessibleControlListener.getLocation(accessibleControlEvent);
                    }
                    gdkRectangle.x = accessibleControlEvent.x;
                    gdkRectangle.y = accessibleControlEvent.y;
                    gdkRectangle.width = accessibleControlEvent.width;
                    gdkRectangle.height = accessibleControlEvent.height;
                }
                OS.g_signal_emit_by_name(this.handle, ATK.bounds_changed, gdkRectangle);
                break;
            }
            case 32780: {
                OS.g_object_notify(this.handle, ATK.accessible_name);
                break;
            }
            case 32781: {
                OS.g_object_notify(this.handle, ATK.accessible_description);
                break;
            }
            case 32782: {
                OS.g_object_notify(this.handle, ATK.accessible_value);
                break;
            }
            case 261: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_complete);
                break;
            }
            case 262: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_stopped);
                break;
            }
            case 263: {
                OS.g_signal_emit_by_name(this.handle, ATK.reload);
                break;
            }
            case 273: {
                break;
            }
            case 274: {
                break;
            }
            case 256: {
                break;
            }
            case 264: {
                OS.g_object_notify(this.handle, ATK.end_index);
                break;
            }
            case 265: {
                OS.g_object_notify(this.handle, ATK.number_of_anchors);
                break;
            }
            case 266: {
                OS.g_object_notify(this.handle, ATK.selected_link);
                break;
            }
            case 269: {
                OS.g_object_notify(this.handle, ATK.start_index);
                break;
            }
            case 267: {
                OS.g_signal_emit_by_name(this.handle, ATK.link_activated);
                break;
            }
            case 268: {
                if (!(object instanceof Integer)) break;
                int n6 = (Integer)object;
                OS.g_signal_emit_by_name(this.handle, ATK.link_selected, n6);
                break;
            }
            case 271: {
                OS.g_object_notify(this.handle, ATK.accessible_hypertext_nlinks);
                break;
            }
            case 512: {
                OS.g_signal_emit_by_name(this.handle, ATK.attributes_changed);
                break;
            }
            case 515: {
                OS.g_object_notify(this.handle, ATK.accessible_table_caption_object);
                break;
            }
            case 516: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_description);
                break;
            }
            case 517: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_header);
                break;
            }
            case 518: {
                if (!(object instanceof int[])) break;
                int[] nArray = (int[])object;
                int n7 = nArray[0];
                int n8 = nArray[1];
                int n9 = nArray[2];
                int n10 = nArray[3];
                int n11 = nArray[4];
                switch (n7) {
                    case 1: {
                        if (n9 > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_deleted, n8, n9);
                        }
                        if (n11 <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_deleted, n10, n11);
                        break;
                    }
                    case 0: {
                        if (n9 > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_inserted, n8, n9);
                        }
                        if (n11 <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_inserted, n10, n11);
                    }
                }
                break;
            }
            case 519: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_description);
                break;
            }
            case 520: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_header);
                break;
            }
            case 521: {
                OS.g_object_notify(this.handle, ATK.accessible_table_summary);
                break;
            }
            case 522: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_attributes_changed);
                break;
            }
            case 283: 
            case 285: {
                int n12 = 0;
                List<AccessibleTextExtendedListener> list = this.accessible.accessibleTextExtendedListeners;
                int n13 = AccessibleObject.size(list);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this.accessible);
                if (n13 > 0) {
                    for (int i = 0; i < n13; ++i) {
                        AccessibleTextListener accessibleTextListener = list.get(i);
                        accessibleTextListener.getCaretOffset(accessibleTextEvent);
                    }
                } else {
                    List<AccessibleTextListener> list2 = this.accessible.accessibleTextListeners;
                    n13 = AccessibleObject.size(list2);
                    if (n13 > 0) {
                        accessibleTextEvent.childID = this.id;
                        for (int i = 0; i < n13; ++i) {
                            AccessibleTextListener accessibleTextListener = list2.get(i);
                            accessibleTextListener.getCaretOffset(accessibleTextEvent);
                        }
                    }
                }
                n12 = accessibleTextEvent.offset;
                OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n12);
                break;
            }
            case 524: {
                if (!(object instanceof Object[])) break;
                Object[] objectArray = (Object[])object;
                int n14 = (Integer)objectArray[0];
                int n15 = (Integer)objectArray[1];
                int n16 = (Integer)objectArray[2];
                switch (n14) {
                    case 1: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n15, n16 - n15);
                        break;
                    }
                    case 0: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n15, n16 - n15);
                    }
                }
                break;
            }
        }
    }

    void sendEvent(int n, Object object, int n2) {
        this.updateChildren();
        AccessibleObject accessibleObject = this.getChildByID(n2);
        if (accessibleObject != null) {
            accessibleObject.sendEvent(n, object);
        }
    }

    void setFocus(int n) {
        this.updateChildren();
        AccessibleObject accessibleObject = this.getChildByID(n);
        if (accessibleObject != null) {
            OS.g_signal_emit_by_name(accessibleObject.handle, ATK.focus_event, 1L, 0L);
            ATK.atk_object_notify_state_change(accessibleObject.handle, 11, true);
        }
    }

    void textCaretMoved(int n) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n);
    }

    void textChanged(int n, int n2, int n3) {
        if (n == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n2, n3);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n2, n3);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        Object object;
        int n;
        AccessibleObject[] accessibleObjectArray;
        List<AccessibleControlListener> list = this.accessible.accessibleControlListeners;
        int n2 = AccessibleObject.size(list);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
        accessibleControlEvent.childID = this.id;
        for (int i = 0; i < n2; ++i) {
            accessibleObjectArray = list.get(i);
            accessibleObjectArray.getChildren(accessibleControlEvent);
        }
        Object[] objectArray = accessibleControlEvent.children;
        accessibleObjectArray = this.children;
        int n3 = objectArray != null ? objectArray.length : 0;
        AccessibleObject[] accessibleObjectArray2 = new AccessibleObject[n3];
        for (n = 0; n < n3; ++n) {
            object = objectArray[n];
            AccessibleObject accessibleObject = null;
            if (object instanceof Integer) {
                int n4 = (Integer)object;
                AccessibleObject accessibleObject2 = accessibleObject = accessibleObjectArray != null && n < accessibleObjectArray.length ? accessibleObjectArray[n] : null;
                if (accessibleObject == null || accessibleObject.id != n4) {
                    accessibleControlEvent = new AccessibleControlEvent(this.accessible);
                    accessibleControlEvent.childID = n4;
                    for (int i = 0; i < n2; ++i) {
                        AccessibleControlListener accessibleControlListener = list.get(i);
                        accessibleControlListener.getChild(accessibleControlEvent);
                    }
                    if (accessibleControlEvent.accessible != null) {
                        accessibleObject = accessibleControlEvent.accessible.getAccessibleObject();
                        if (accessibleObject != null) {
                            OS.g_object_ref(accessibleObject.handle);
                        }
                    } else {
                        accessibleObject = AccessibleFactory.createChildAccessible(this.accessible, n4);
                    }
                    accessibleObject.id = n4;
                } else {
                    OS.g_object_ref(accessibleObject.handle);
                }
            } else if (object instanceof Accessible && (accessibleObject = ((Accessible)object).getAccessibleObject()) != null) {
                OS.g_object_ref(accessibleObject.handle);
            }
            if (accessibleObject == null) continue;
            accessibleObject.index = n;
            accessibleObject.parent = this;
            accessibleObjectArray2[n] = accessibleObject;
        }
        if (accessibleObjectArray != null) {
            for (n = 0; n < accessibleObjectArray.length; ++n) {
                object = accessibleObjectArray[n];
                if (object == null) continue;
                OS.g_object_unref(((AccessibleObject)object).handle);
            }
        }
        this.children = accessibleObjectArray2;
    }
}

