/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.CharacterEntityReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.NumericCharacterReference;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StreamedSource;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    static int MAX_ENTITY_REFERENCE_LENGTH;
    private static final int TAB_LENGTH = 4;

    CharacterReference(Source source, int begin, int end, int codePoint) {
        super(source, begin, end);
        this.codePoint = codePoint;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public final void appendCharTo(Appendable appendable) throws IOException {
        this.appendCharTo(appendable, Config.ConvertNonBreakingSpaces);
    }

    private void appendCharTo(Appendable appendable, boolean convertNonBreakingSpaces) throws IOException {
        if (Character.isSupplementaryCodePoint(this.codePoint)) {
            appendable.append(CharacterReference.getHighSurrogate(this.codePoint));
            appendable.append(CharacterReference.getLowSurrogate(this.codePoint));
        } else {
            char ch = this.getChar();
            if (ch == '\u00a0' && convertNonBreakingSpaces) {
                appendable.append(' ');
            } else {
                appendable.append(ch);
            }
        }
    }

    public boolean isTerminated() {
        return this.source.charAt(this.end - 1) == ';';
    }

    public static String encode(CharSequence unencodedText) {
        return CharacterReference.encode(unencodedText, true);
    }

    public static String encode(CharSequence unencodedText, boolean insideAttributeValue) {
        if (unencodedText == null) {
            return null;
        }
        try {
            return CharacterReference.appendEncode((Appendable)new StringBuilder(unencodedText.length() * 2), unencodedText, insideAttributeValue).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encode(char ch) {
        try {
            return CharacterReference.appendEncode((Appendable)new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH), ch, true).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        try {
            StringBuilder appendable = new StringBuilder(unencodedText.length() * 2);
            int beginPos = 0;
            int endPos = unencodedText.length();
            if (unencodedText instanceof Segment) {
                int segmentOffset;
                Segment segment = (Segment)unencodedText;
                beginPos = segmentOffset = segment.getBegin();
                endPos += segmentOffset;
                unencodedText = segment.source;
            }
            for (int i = beginPos; i < endPos; ++i) {
                int spaceCount;
                char ch = unencodedText.charAt(i);
                if (!CharacterReference.isWhiteSpace(ch)) {
                    CharacterReference.appendEncode((Appendable)appendable, ch, false);
                    continue;
                }
                int nexti = i + 1;
                if (ch != ' ') {
                    if (ch != '\t') {
                        if (ch == '\r' && nexti < endPos && unencodedText.charAt(nexti) == '\n') {
                            ++i;
                        }
                        appendable.append((CharSequence)"<br />");
                        continue;
                    }
                    spaceCount = 4;
                } else {
                    spaceCount = 1;
                }
                while (nexti < endPos) {
                    ch = unencodedText.charAt(nexti);
                    if (ch == ' ') {
                        ++spaceCount;
                    } else {
                        if (ch != '\t') break;
                        spaceCount += 4;
                    }
                    ++nexti;
                }
                if (spaceCount == 1) {
                    appendable.append(' ');
                    continue;
                }
                if (spaceCount % 2 == 1) {
                    appendable.append(' ');
                }
                while (spaceCount >= 2) {
                    appendable.append((CharSequence)"&nbsp; ");
                    spaceCount -= 2;
                }
                i = nexti - 1;
            }
            return ((Object)appendable).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decode(CharSequence encodedText) {
        return CharacterReference.decode(encodedText, false, Config.ConvertNonBreakingSpaces);
    }

    public static String decode(CharSequence encodedText, boolean insideAttributeValue) {
        return CharacterReference.decode(encodedText, insideAttributeValue, Config.ConvertNonBreakingSpaces);
    }

    static final String decode(CharSequence encodedText, boolean insideAttributeValue, boolean convertNonBreakingSpaces) {
        if (encodedText == null) {
            return null;
        }
        String encodedTextString = encodedText.toString();
        int firstAmpersandPos = encodedTextString.indexOf(38);
        if (firstAmpersandPos == -1) {
            return encodedTextString;
        }
        try {
            return CharacterReference.appendDecode((Appendable)new StringBuilder(encodedText.length()), encodedText, firstAmpersandPos, insideAttributeValue, convertNonBreakingSpaces).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decodeCollapseWhiteSpace(CharSequence text) {
        return CharacterReference.decodeCollapseWhiteSpace(text, Config.ConvertNonBreakingSpaces);
    }

    static String decodeCollapseWhiteSpace(CharSequence text, boolean convertNonBreakingSpaces) {
        return CharacterReference.decode(CharacterReference.appendCollapseWhiteSpace(new StringBuilder(text.length()), text), false, convertNonBreakingSpaces);
    }

    public static String reencode(CharSequence encodedText) {
        return CharacterReference.encode(CharacterReference.decode(encodedText, true), true);
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int codePoint) {
        String characterReferenceString = null;
        if (codePoint != 39) {
            characterReferenceString = CharacterEntityReference.getCharacterReferenceString(codePoint);
        }
        if (characterReferenceString == null) {
            characterReferenceString = NumericCharacterReference.getCharacterReferenceString(codePoint);
        }
        return characterReferenceString;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int codePoint) {
        try {
            return CharacterReference.appendDecimalCharacterReferenceString(new StringBuilder(), codePoint).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int codePoint) {
        try {
            return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuilder(), codePoint).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int codePoint) {
        try {
            return CharacterReference.appendUnicodeText(new StringBuilder(), codePoint).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static final Appendable appendUnicodeText(Appendable appendable, int codePoint) throws IOException {
        appendable.append("U+");
        String hex = Integer.toString(codePoint, 16).toUpperCase();
        for (int i = 4 - hex.length(); i > 0; --i) {
            appendable.append('0');
        }
        appendable.append(hex);
        return appendable;
    }

    public static CharacterReference parse(CharSequence characterReferenceText) {
        return CharacterReference.construct(new Source(characterReferenceText, true), 0, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence characterReferenceText) {
        CharacterReference characterReference = CharacterReference.parse(characterReferenceText);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    @Deprecated
    public static final boolean requiresEncoding(char ch) {
        return Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(ch, true);
    }

    public static Writer getEncodingFilterWriter(Writer writer) {
        return new EncodingFilterWriter(writer);
    }

    static Appendable appendEncode(Appendable appendable, CharSequence unencodedText, boolean insideAttributeValue) throws IOException {
        if (unencodedText == null) {
            return appendable;
        }
        int beginPos = 0;
        int endPos = unencodedText.length();
        if (unencodedText instanceof Segment) {
            int segmentOffset;
            Segment segment = (Segment)unencodedText;
            beginPos = segmentOffset = segment.getBegin();
            endPos += segmentOffset;
            unencodedText = segment.source;
        }
        for (int i = beginPos; i < endPos; ++i) {
            CharacterReference.appendEncode(appendable, unencodedText.charAt(i), insideAttributeValue);
        }
        return appendable;
    }

    private static final Appendable appendEncode(Appendable appendable, char ch, boolean insideAttributeValue) throws IOException {
        if (Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(ch, insideAttributeValue)) {
            String characterEntityReferenceName = CharacterEntityReference.getName(ch);
            if (characterEntityReferenceName != null && ch != '\'') {
                CharacterEntityReference.appendCharacterReferenceString(appendable, characterEntityReferenceName);
            } else {
                CharacterReference.appendDecimalCharacterReferenceString(appendable, ch);
            }
        } else {
            appendable.append(ch);
        }
        return appendable;
    }

    static CharacterReference getPrevious(Source source, int pos) {
        return CharacterReference.getPrevious(source, pos, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    static CharacterReference getNext(Source source, int pos) {
        return CharacterReference.getNext(source, pos, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    private static CharacterReference getPrevious(Source source, int pos, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source.getParseText();
        pos = parseText.lastIndexOf('&', pos);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            pos = parseText.lastIndexOf('&', pos - 1);
        }
        return null;
    }

    private static CharacterReference getNext(Source source, int pos, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source.getParseText();
        pos = parseText.indexOf('&', pos);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            pos = parseText.indexOf('&', pos + 1);
        }
        return null;
    }

    static final Appendable appendHexadecimalCharacterReferenceString(Appendable appendable, int codePoint) throws IOException {
        return appendable.append("&#x").append(Integer.toString(codePoint, 16)).append(';');
    }

    static final Appendable appendDecimalCharacterReferenceString(Appendable appendable, int codePoint) throws IOException {
        return appendable.append("&#").append(Integer.toString(codePoint)).append(';');
    }

    static CharacterReference construct(Source source, int begin, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        try {
            if (source.getParseText().charAt(begin) != '&') {
                return null;
            }
            return source.getParseText().charAt(begin + 1) == '#' ? NumericCharacterReference.construct(source, begin, unterminatedCharacterReferenceSettings) : CharacterEntityReference.construct(source, begin, unterminatedCharacterReferenceSettings.characterEntityReferenceMaxCodePoint);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private static Appendable appendDecode(Appendable appendable, CharSequence encodedText, int searchBegin, boolean insideAttributeValue, boolean convertNonBreakingSpaces) throws IOException {
        if (encodedText instanceof Segment) {
            return CharacterReference.appendDecode(appendable, (Segment)encodedText, searchBegin, insideAttributeValue, convertNonBreakingSpaces);
        }
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(insideAttributeValue);
        StreamedSource streamedSource = new StreamedSource(encodedText).setHandleTags(false).setUnterminatedCharacterReferenceSettings(unterminatedCharacterReferenceSettings).setSearchBegin(searchBegin);
        for (Segment segment : streamedSource) {
            if (segment instanceof CharacterReference) {
                ((CharacterReference)segment).appendCharTo(appendable, convertNonBreakingSpaces);
                continue;
            }
            appendable.append(segment.toString());
        }
        return appendable;
    }

    private static Appendable appendDecode(Appendable appendable, Segment segment, int searchBegin, boolean insideAttributeValue, boolean convertNonBreakingSpaces) throws IOException {
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(insideAttributeValue);
        Source source = segment.source;
        ParseText parseText = source.getParseText();
        int end = segment.getEnd();
        int begin = segment.getBegin();
        int pos = parseText.indexOf('&', begin + searchBegin, end);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                appendable.append(source.substring(begin, pos));
                characterReference.appendCharTo(appendable, convertNonBreakingSpaces);
                begin = characterReference.getEnd();
                pos = parseText.indexOf('&', begin, end);
                continue;
            }
            pos = parseText.indexOf('&', pos + 1, end);
        }
        appendable.append(source.substring(begin, end));
        return appendable;
    }

    private static char getHighSurrogate(int codePoint) {
        return (char)(55232 + (codePoint >> 10));
    }

    private static char getLowSurrogate(int codePoint) {
        return (char)(56320 + (codePoint & 0x3FF));
    }

    private static final class EncodingFilterWriter
    extends FilterWriter {
        StringBuilder sb = new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH);

        public EncodingFilterWriter(Writer writer) {
            super(writer);
        }

        public void write(char ch) throws IOException {
            this.sb.setLength(0);
            CharacterReference.appendEncode(this.sb, ch, true);
            if (this.sb.length() == 1) {
                this.out.write(this.sb.charAt(0));
            } else {
                this.out.append(this.sb);
            }
        }

        @Override
        public void write(int chInt) throws IOException {
            this.write((char)chInt);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                this.write(cbuf[i]);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                this.write(str.charAt(i));
            }
        }
    }
}

