/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHRGINFO;
import org.eclipse.swt.internal.win32.TRACKMOUSEEVENT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int DRAW_BACKGROUND = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int TRACK_MOUSE = 8192;
    static final int FOREIGN_HANDLE = 16384;
    static final int DRAG_DETECT = 32768;
    static final int MOVE_OCCURRED = 65536;
    static final int MOVE_DEFERRED = 131072;
    static final int RESIZE_OCCURRED = 262144;
    static final int RESIZE_DEFERRED = 524288;
    static final int IGNORE_WM_CHANGEUISTATE = 0x100000;
    static final int SKIN_NEEDED = 0x200000;
    static final int HAS_AUTO_DIRECTION = 0x400000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final char LRE = '\u202a';
    static final char RLE = '\u202b';
    static final int AUTO_TEXT_DIRECTION = 0x6000000;
    static final int MAJOR = 5;
    static final int MINOR = 80;

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
        this.reskinWidget();
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    void _removeListener(int n, Listener listener) {
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        return 0L;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkOpened() {
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpened();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread() && display.threadId != OS.GetCurrentThreadId()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    long DeferWindowPos(long l, long l2, long l3, int n, int n2, int n3, int n4, int n5) {
        if (OS.IsWinCE && (n5 & 1) == 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(l2, rECT);
            if (n4 == rECT.bottom - rECT.top && n3 == rECT.right - rECT.left) {
                n5 &= 0xFFFFFFDF;
                n5 |= 1;
            }
        }
        return OS.DeferWindowPos(l, l2, l3, n, n2, n3, n4, n5);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    boolean dragDetect(long l, int n, int n2, boolean bl, boolean[] blArray, boolean[] blArray2) {
        if (blArray2 != null) {
            blArray2[0] = false;
        }
        if (blArray != null) {
            blArray[0] = true;
        }
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        OS.ClientToScreen(l, pOINT);
        return OS.DragDetect(l, pOINT);
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    Widget findItem(long l) {
        return null;
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, false);
    }

    char[] fixMnemonic(String string, boolean bl) {
        char[] cArray = new char[string.length() + 1];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '&') {
                if (n + 1 < cArray.length && cArray[n + 1] == '&') {
                    cArray[n2++] = bl ? 32 : cArray[n];
                    ++n;
                }
                ++n;
                continue;
            }
            cArray[n2++] = cArray[n++];
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        return cArray;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            for (int i = 1; i < objectArray.length; i += 2) {
                if (!string.equals(objectArray[i])) continue;
                return objectArray[i + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int n) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n);
    }

    Menu getMenu() {
        return null;
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    public boolean isAutoDirection() {
        return (this.state & 0x400000) != 0;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void mapEvent(long l, Event event) {
    }

    GC new_GC(GCData gCData) {
        return null;
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void release(boolean bl) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._removeListener(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    public void reskin(int n) {
        this.checkWidget();
        this.reskinWidget();
        if ((n & 1) != 0) {
            this.reskinChildren(n);
        }
    }

    void reskinChildren(int n) {
    }

    void reskinWidget() {
        if ((this.state & 0x200000) != 0x200000) {
            this.state |= 0x200000;
            this.display.addSkinnableWidget(this);
        }
    }

    boolean sendDragEvent(int n, int n2, int n3) {
        Event event = new Event();
        event.button = n;
        event.setLocationInPixels(n2, n3);
        this.setInputState(event, 29);
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4) {
        Event event = new Event();
        event.button = n;
        event.setLocationInPixels(n3, n4);
        event.stateMask = n2;
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            display.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    void sendSelectionEvent(int n) {
        this.sendSelectionEvent(n, null, false);
    }

    void sendSelectionEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        this.setInputState(event, n);
        this.sendEvent(n, event, bl);
    }

    boolean sendKeyEvent(int n, int n2, long l, long l2) {
        Event event = new Event();
        if (!this.setKeyState(event, n, l, l2)) {
            return true;
        }
        return this.sendKeyEvent(n, n2, l, l2, event);
    }

    boolean sendKeyEvent(int n, int n2, long l, long l2, Event event) {
        this.sendEvent(n, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendMouseEvent(int n, int n2, long l, int n3, long l2, long l3) {
        return this.sendMouseEvent(n, n2, this.display.getClickCount(n, n2, l, l3), 0, false, l, n3, l2, l3);
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, boolean bl, long l, int n5, long l2, long l3) {
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        Event event = new Event();
        event.button = n2;
        event.detail = n4;
        event.count = n3;
        event.setLocationInPixels(OS.GET_X_LPARAM(l3), OS.GET_Y_LPARAM(l3));
        this.setInputState(event, n);
        this.mapEvent(l, event);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        return event.doit;
    }

    boolean sendMouseWheelEvent(int n, long l, long l2, long l3) {
        int n2 = OS.GET_WHEEL_DELTA_WPARAM(l2);
        int n3 = 0;
        if (n == 37) {
            int[] nArray = new int[1];
            OS.SystemParametersInfo(104, 0, nArray, 0);
            if (nArray[0] == -1) {
                n3 = 2;
            } else {
                n3 = 1;
                n2 *= nArray[0];
            }
            if ((n2 ^ this.display.scrollRemainder) >= 0) {
                n2 += this.display.scrollRemainder;
            }
            this.display.scrollRemainder = n2 % 120;
        } else {
            if ((n2 ^ this.display.scrollHRemainder) >= 0) {
                n2 += this.display.scrollHRemainder;
            }
            this.display.scrollHRemainder = n2 % 120;
            n2 = -n2;
        }
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        int n4 = n2 / 120;
        POINT pOINT = new POINT();
        OS.POINTSTOPOINT(pOINT, l3);
        OS.ScreenToClient(l, pOINT);
        l3 = OS.MAKELPARAM(pOINT.x, pOINT.y);
        return this.sendMouseEvent(n, 0, n4, n3, true, l, 522, l2, l3);
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            for (n = 1; n < objectArray.length && !string.equals(objectArray[n]); n += 2) {
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
        if (string.equals("org.eclipse.swt.skin.class") || string.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    boolean sendFocusEvent(int n) {
        this.sendEvent(n);
        return true;
    }

    boolean setInputState(Event event, int n) {
        if (OS.GetKeyState(18) < 0) {
            event.stateMask |= 0x10000;
        }
        if (OS.GetKeyState(16) < 0) {
            event.stateMask |= 0x20000;
        }
        if (OS.GetKeyState(17) < 0) {
            event.stateMask |= 0x40000;
        }
        if (OS.GetKeyState(1) < 0) {
            event.stateMask |= 0x80000;
        }
        if (OS.GetKeyState(4) < 0) {
            event.stateMask |= 0x100000;
        }
        if (OS.GetKeyState(2) < 0) {
            event.stateMask |= 0x200000;
        }
        if (this.display.xMouse) {
            if (OS.GetKeyState(5) < 0) {
                event.stateMask |= 0x800000;
            }
            if (OS.GetKeyState(6) < 0) {
                event.stateMask |= 0x2000000;
            }
        }
        switch (n) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int n, long l, long l2) {
        switch (this.display.lastAscii) {
            case 127: {
                if (this.display.lastKey != 8) break;
                this.display.lastAscii = 8;
                break;
            }
            case 10: {
                if (this.display.lastKey != 13) break;
                this.display.lastAscii = 13;
            }
        }
        if (this.display.lastKey == 13 && this.display.lastAscii == 13 && (l2 & 0x1000000L) != 0L) {
            this.display.lastKey = 0x1000050;
        }
        this.setLocationMask(event, n, l, l2);
        if (this.display.lastVirtual) {
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (this.display.lastKey == 3) {
                this.display.lastAscii = 0;
            }
            event.keyCode = Display.translateKey(this.display.lastKey);
        } else {
            event.keyCode = this.display.lastKey;
        }
        if (this.display.lastAscii != 0 || this.display.lastNull) {
            event.character = Display.mbcsToWcs((char)this.display.lastAscii);
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !this.display.lastNull) {
            return false;
        }
        return this.setInputState(event, n);
    }

    int setLocationMask(Event event, int n, long l, long l2) {
        int n2 = 0;
        if (this.display.lastVirtual) {
            switch (this.display.lastKey) {
                case 16: {
                    if (OS.GetKeyState(160) < 0) {
                        n2 = 16384;
                    }
                    if (OS.GetKeyState(161) >= 0) break;
                    n2 = 131072;
                    break;
                }
                case 144: {
                    n2 = 2;
                    break;
                }
                case 17: 
                case 18: {
                    n2 = (l2 & 0x1000000L) == 0L ? 16384 : 131072;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 45: 
                case 46: {
                    if ((l2 & 0x1000000L) != 0L) break;
                    n2 = 2;
                }
            }
            if (this.display.numpadKey(this.display.lastKey) != 0) {
                n2 = 2;
            }
        } else if (this.display.lastKey == 0x1000050) {
            n2 = 2;
        }
        event.keyLocation = n2;
        return n2;
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        return false;
    }

    boolean SetWindowPos(long l, long l2, int n, int n2, int n3, int n4, int n5) {
        if (OS.IsWinCE && (n5 & 1) == 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(l, rECT);
            if (n4 == rECT.bottom - rECT.top && n3 == rECT.right - rECT.left) {
                n5 &= 0xFFFFFFDF;
                n5 |= 1;
            }
        }
        return OS.SetWindowPos(l, l2, n, n2, n3, n4, n5);
    }

    boolean showMenu(int n, int n2) {
        return this.showMenu(n, n2, 0);
    }

    boolean showMenu(int n, int n2, int n3) {
        Event event = new Event();
        event.setLocationInPixels(n, n2);
        event.detail = n3;
        if (event.detail == 1) {
            this.updateMenuLocation(event);
        }
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return true;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            Point point = event.getLocationInPixels();
            if (n != point.x || n2 != point.y) {
                menu.setLocation(event.getLocation());
            }
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    void updateMenuLocation(Event event) {
    }

    LRESULT wmCaptureChanged(long l, long l2, long l3) {
        this.display.captureChanged = true;
        return null;
    }

    LRESULT wmChar(long l, long l2, long l3) {
        byte by;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(by = (byte)(l2 & 0xFFL))) {
            return null;
        }
        this.display.lastAscii = (int)l2;
        boolean bl = this.display.lastNull = l2 == 0L;
        if (!this.sendKeyEvent(1, 258, l2, l3)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmContextMenu(long l, long l2, long l3) {
        if (l2 != l) {
            return null;
        }
        if (OS.IsWinCE) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (l3 != -1L) {
            POINT pOINT = new POINT();
            OS.POINTSTOPOINT(pOINT, l3);
            n = pOINT.x;
            n2 = pOINT.y;
            n3 = 0;
            OS.ScreenToClient(l, pOINT);
            RECT rECT = new RECT();
            OS.GetClientRect(l, rECT);
            if (!OS.PtInRect(rECT, pOINT)) {
                return null;
            }
        } else {
            int n4 = OS.GetMessagePos();
            n = OS.GET_X_LPARAM(n4);
            n2 = OS.GET_Y_LPARAM(n4);
            n3 = 1;
        }
        return this.showMenu(n, n2, n3) ? LRESULT.ZERO : null;
    }

    LRESULT wmIMEChar(long l, long l2, long l3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = (int)l2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, l2, l3)) {
            return LRESULT.ONE;
        }
        this.sendKeyEvent(2, 646, l2, l3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return LRESULT.ONE;
    }

    LRESULT wmKeyDown(long l, long l2, long l3) {
        byte by;
        switch ((int)l2) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((l3 & 0x40000000L) == 0L) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(by = (byte)(l2 & 0xFFL))) {
            return null;
        }
        by = 0;
        if (OS.IsWinCE) {
            switch ((int)l2) {
                case 8: {
                    by = (byte)8;
                    break;
                }
                case 13: {
                    by = (byte)13;
                    break;
                }
                case 46: {
                    by = (byte)127;
                    break;
                }
                case 27: {
                    by = (byte)27;
                    break;
                }
                case 9: {
                    by = (byte)9;
                }
            }
        } else {
            by = (byte)OS.MapVirtualKey((int)l2, 2);
            if (2534 <= by && by <= 2543 || 2406 <= by && by <= 2415) {
                by = (byte)l2;
            }
        }
        if (OS.IsWinNT ? (by & Integer.MIN_VALUE) != 0 : (by & 0x8000) != 0) {
            return null;
        }
        MSG mSG = new MSG();
        int n = 10420226;
        if (OS.PeekMessage(mSG, l, 259, 259, n)) {
            this.display.lastDead = true;
            this.display.lastVirtual = by == 0;
            this.display.lastKey = this.display.lastVirtual ? (int)l2 : by;
            return null;
        }
        if (this.isDisposed()) {
            return LRESULT.ONE;
        }
        boolean bl = this.display.lastVirtual = by == 0 || this.display.numpadKey((int)l2) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = (int)l2;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                if (this.display.asciiKey(this.display.lastKey) != 0) {
                    return null;
                }
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            int n2;
            this.display.lastKey = (int)OS.CharLower(by);
            if (l2 == 3L) {
                this.display.lastVirtual = true;
            }
            if ((n2 = this.display.asciiKey((int)l2)) != 0) {
                if (n2 == 32) {
                    return null;
                }
                if (n2 != (int)l2) {
                    return null;
                }
                if (l2 == 3L) {
                    return null;
                }
            }
            if (OS.GetKeyState(17) >= 0) {
                return null;
            }
            if (OS.GetKeyState(16) < 0) {
                this.display.lastAscii = this.display.shiftedKey((int)l2);
                if (this.display.lastAscii == 0) {
                    this.display.lastAscii = by;
                }
            } else {
                this.display.lastAscii = (int)OS.CharLower(by);
            }
            if (this.display.lastAscii == 64) {
                return null;
            }
            this.display.lastAscii = this.display.controlKey(this.display.lastAscii);
        }
        if (!this.sendKeyEvent(1, 256, l2, l3)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmKeyUp(long l, long l2, long l3) {
        Display display = this.display;
        if (OS.IsWinCE && 193L <= l2 && l2 <= 198L) {
            int n;
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            Event event = new Event();
            event.detail = (int)l2 - 193 + 1;
            int n2 = n = (l3 & 0x40000000L) != 0L ? 34 : 33;
            if (this.setInputState(event, n)) {
                this.sendEvent(n, event);
            }
            return null;
        }
        if (!this.hooks(2) && !display.filters(2)) {
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            return null;
        }
        int n = 0;
        if (OS.IsWinCE) {
            switch ((int)l2) {
                case 8: {
                    n = 8;
                    break;
                }
                case 13: {
                    n = 13;
                    break;
                }
                case 46: {
                    n = 127;
                    break;
                }
                case 27: {
                    n = 27;
                    break;
                }
                case 9: {
                    n = 9;
                }
            }
        } else {
            n = OS.MapVirtualKey((int)l2, 2);
        }
        if (OS.IsWinNT ? (n & Integer.MIN_VALUE) != 0 : (n & 0x8000) != 0) {
            return null;
        }
        if (display.lastDead) {
            return null;
        }
        boolean bl = display.lastVirtual = n == 0 || display.numpadKey((int)l2) != 0;
        if (display.lastVirtual) {
            display.lastKey = (int)l2;
        } else {
            if (l2 == 3L) {
                display.lastVirtual = true;
            }
            if (display.lastKey == 0) {
                display.lastAscii = 0;
                display.lastDead = false;
                display.lastNull = false;
                return null;
            }
        }
        LRESULT lRESULT = null;
        if (!this.sendKeyEvent(2, 257, l2, l3)) {
            lRESULT = LRESULT.ONE;
        }
        display.lastAscii = 0;
        display.lastKey = 0;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        return lRESULT;
    }

    LRESULT wmKillFocus(long l, long l2, long l3) {
        this.display.scrollHRemainder = 0;
        this.display.scrollRemainder = 0;
        long l4 = this.callWindowProc(l, 8, l2, l3);
        this.sendFocusEvent(16);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (l4 == 0L) {
            return LRESULT.ZERO;
        }
        return new LRESULT(l4);
    }

    LRESULT wmLButtonDblClk(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, l, 513, l2, l3);
        lRESULT = this.sendMouseEvent(8, 1, l, 515, l2, l3) ? new LRESULT(this.callWindowProc(l, 515, l2, l3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        return lRESULT;
    }

    LRESULT wmLButtonDown(long l, long l2, long l3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        int n = OS.GET_X_LPARAM(l3);
        int n2 = OS.GET_Y_LPARAM(l3);
        boolean[] blArray = null;
        boolean[] blArray2 = null;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = display.getClickCount(3, 1, l, l3);
        if (n3 == 1 && (this.state & 0x8000) != 0 && this.hooks(29) && !OS.IsWinCE) {
            blArray2 = new boolean[1];
            blArray = new boolean[1];
            bl = this.dragDetect(l, n, n2, true, blArray2, blArray);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            bl2 = OS.GetKeyState(1) < 0;
        }
        display.captureChanged = false;
        boolean bl3 = this.sendMouseEvent(3, 1, n3, 0, false, l, 513, l2, l3);
        lRESULT = bl3 && (blArray == null || !blArray[0]) ? new LRESULT(this.callWindowProc(l, 513, l2, l3)) : LRESULT.ZERO;
        if (OS.IsPPC) {
            boolean bl4;
            Menu menu = this.getMenu();
            boolean bl5 = bl4 = menu != null && !menu.isDisposed();
            if (bl4 || this.hooks(35)) {
                SHRGINFO sHRGINFO = new SHRGINFO();
                sHRGINFO.cbSize = SHRGINFO.sizeof;
                sHRGINFO.hwndClient = l;
                sHRGINFO.ptDown_x = n;
                sHRGINFO.ptDown_y = n2;
                sHRGINFO.dwFlags = 1;
                int n4 = OS.SHRecognizeGesture(sHRGINFO);
                if (n4 == 1000) {
                    this.showMenu(n, n2);
                }
            }
        }
        if (bl2 && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        if (bl) {
            this.sendDragEvent(1, n, n2);
        } else if (blArray2 != null && blArray2[0] && OS.GetKeyState(27) >= 0) {
            OS.SendMessage(l, 514, l2, l3);
        }
        return lRESULT;
    }

    LRESULT wmLButtonUp(long l, long l2, long l3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        lRESULT = this.sendMouseEvent(4, 1, l, 514, l2, l3) ? new LRESULT(this.callWindowProc(l, 514, l2, l3)) : LRESULT.ZERO;
        int n = 19;
        if (display.xMouse) {
            n |= 0x60;
        }
        if ((l2 & (long)n) == 0L && OS.GetCapture() == l) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmMButtonDblClk(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 2, l, 519, l2, l3);
        lRESULT = this.sendMouseEvent(8, 2, l, 521, l2, l3) ? new LRESULT(this.callWindowProc(l, 521, l2, l3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        return lRESULT;
    }

    LRESULT wmMButtonDown(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        lRESULT = this.sendMouseEvent(3, 2, l, 519, l2, l3) ? new LRESULT(this.callWindowProc(l, 519, l2, l3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        return lRESULT;
    }

    LRESULT wmMButtonUp(long l, long l2, long l3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        lRESULT = this.sendMouseEvent(4, 2, l, 520, l2, l3) ? new LRESULT(this.callWindowProc(l, 520, l2, l3)) : LRESULT.ZERO;
        int n = 19;
        if (display.xMouse) {
            n |= 0x60;
        }
        if ((l2 & (long)n) == 0L && OS.GetCapture() == l) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmMouseHover(long l, long l2, long l3) {
        if (!this.sendMouseEvent(32, 0, l, 673, l2, l3)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseLeave(long l, long l2, long l3) {
        if (!this.hooks(7) && !this.filters(7)) {
            return null;
        }
        int n = OS.GetMessagePos();
        POINT pOINT = new POINT();
        OS.POINTSTOPOINT(pOINT, n);
        OS.ScreenToClient(l, pOINT);
        l3 = OS.MAKELPARAM(pOINT.x, pOINT.y);
        if (!this.sendMouseEvent(7, 0, l, 675, l2, l3)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseMove(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        int n = OS.GetMessagePos();
        if (n != display.lastMouse || display.captureChanged) {
            if (!OS.IsWinCE) {
                boolean bl;
                boolean bl2 = (this.state & 0x2000) != 0;
                boolean bl3 = this.hooks(6) || display.filters(6);
                boolean bl4 = this.hooks(7) || display.filters(7);
                boolean bl5 = bl = this.hooks(32) || display.filters(32);
                if (bl2 || bl3 || bl4 || bl) {
                    TRACKMOUSEEVENT tRACKMOUSEEVENT = new TRACKMOUSEEVENT();
                    tRACKMOUSEEVENT.cbSize = TRACKMOUSEEVENT.sizeof;
                    tRACKMOUSEEVENT.dwFlags = 0x40000000;
                    tRACKMOUSEEVENT.hwndTrack = l;
                    OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    if (tRACKMOUSEEVENT.dwFlags == 0) {
                        tRACKMOUSEEVENT.dwFlags = 3;
                        tRACKMOUSEEVENT.hwndTrack = l;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                        if (bl3) {
                            MSG mSG = new MSG();
                            int n2 = 10420227;
                            while (OS.PeekMessage(mSG, 0L, 675, 675, n2)) {
                                OS.TranslateMessage(mSG);
                                OS.DispatchMessage(mSG);
                            }
                            this.sendMouseEvent(6, 0, l, 512, l2, l3);
                        }
                    } else {
                        tRACKMOUSEEVENT.dwFlags = 1;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    }
                }
            }
            if (n != display.lastMouse) {
                display.lastMouse = n;
                if (!this.sendMouseEvent(5, 0, l, 512, l2, l3)) {
                    lRESULT = LRESULT.ZERO;
                }
            }
        }
        display.captureChanged = false;
        return lRESULT;
    }

    LRESULT wmMouseWheel(long l, long l2, long l3) {
        return this.sendMouseWheelEvent(37, l, l2, l3) ? null : LRESULT.ZERO;
    }

    LRESULT wmMouseHWheel(long l, long l2, long l3) {
        return this.sendMouseWheelEvent(38, l, l2, l3) ? null : LRESULT.ZERO;
    }

    LRESULT wmNCPaint(long l, long l2, long l3) {
        return null;
    }

    LRESULT wmPaint(long l, long l2, long l3) {
        if (!this.hooks(9) && !this.filters(9)) {
            return null;
        }
        long l4 = 0L;
        if (OS.IsWinCE) {
            RECT rECT = new RECT();
            OS.GetUpdateRect(l, rECT, false);
            l4 = this.callWindowProc(l, 15, l2, l3);
            OS.HideCaret(l);
            OS.InvalidateRect(l, rECT, false);
            OS.ShowCaret(l);
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            GCData gCData = new GCData();
            gCData.ps = pAINTSTRUCT;
            gCData.hwnd = l;
            GC gC = this.new_GC(gCData);
            if (gC != null) {
                int n = pAINTSTRUCT.right - pAINTSTRUCT.left;
                int n2 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                if (n != 0 && n2 != 0) {
                    Event event = new Event();
                    event.gc = gC;
                    event.setBoundsInPixels(new Rectangle(pAINTSTRUCT.left, pAINTSTRUCT.top, n, n2));
                    this.sendEvent(9, event);
                    event.gc = null;
                }
                gC.dispose();
            }
        } else {
            long l5 = OS.CreateRectRgn(0, 0, 0, 0);
            OS.GetUpdateRgn(l, l5, false);
            l4 = this.callWindowProc(l, 15, l2, l3);
            GCData gCData = new GCData();
            gCData.hwnd = l;
            GC gC = this.new_GC(gCData);
            if (gC != null) {
                OS.HideCaret(l);
                RECT rECT = new RECT();
                OS.GetRgnBox(l5, rECT);
                int n = rECT.right - rECT.left;
                int n3 = rECT.bottom - rECT.top;
                if (n != 0 && n3 != 0) {
                    long l6 = gC.handle;
                    OS.SelectClipRgn(l6, l5);
                    OS.SetMetaRgn(l6);
                    Event event = new Event();
                    event.gc = gC;
                    event.setBoundsInPixels(new Rectangle(rECT.left, rECT.top, n, n3));
                    this.sendEvent(9, event);
                    event.gc = null;
                }
                gC.dispose();
                OS.ShowCaret(l);
            }
            OS.DeleteObject(l5);
        }
        if (l4 == 0L) {
            return LRESULT.ZERO;
        }
        return new LRESULT(l4);
    }

    LRESULT wmPrint(long l, long l2, long l3) {
        int n;
        if ((l3 & 2L) != 0L && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && ((n = OS.GetWindowLong(l, -20)) & 0x200) != 0) {
            long l4 = this.callWindowProc(l, 791, l2, l3);
            RECT rECT = new RECT();
            OS.GetWindowRect(l, rECT);
            rECT.right -= rECT.left;
            rECT.bottom -= rECT.top;
            rECT.top = 0;
            rECT.left = 0;
            int n2 = OS.GetSystemMetrics(45);
            OS.ExcludeClipRect(l2, n2, n2, rECT.right - n2, rECT.bottom - n2);
            OS.DrawThemeBackground(this.display.hEditTheme(), l2, 1, 1, rECT, null);
            return new LRESULT(l4);
        }
        return null;
    }

    LRESULT wmRButtonDblClk(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, l, 516, l2, l3);
        lRESULT = this.sendMouseEvent(8, 3, l, 518, l2, l3) ? new LRESULT(this.callWindowProc(l, 518, l2, l3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        return lRESULT;
    }

    LRESULT wmRButtonDown(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        lRESULT = this.sendMouseEvent(3, 3, l, 516, l2, l3) ? new LRESULT(this.callWindowProc(l, 516, l2, l3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        return lRESULT;
    }

    LRESULT wmRButtonUp(long l, long l2, long l3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        if (this.sendMouseEvent(4, 3, l, 517, l2, l3)) {
            lRESULT = new LRESULT(this.callWindowProc(l, 517, l2, l3));
        } else {
            OS.DefWindowProc(l, 517, l2, l3);
            lRESULT = LRESULT.ZERO;
        }
        int n = 19;
        if (display.xMouse) {
            n |= 0x60;
        }
        if ((l2 & (long)n) == 0L && OS.GetCapture() == l) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmSetFocus(long l, long l2, long l3) {
        long l4 = this.callWindowProc(l, 7, l2, l3);
        this.sendFocusEvent(15);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (l4 == 0L) {
            return LRESULT.ZERO;
        }
        return new LRESULT(l4);
    }

    LRESULT wmSysChar(long l, long l2, long l3) {
        Display display = this.display;
        display.lastAscii = (int)l2;
        boolean bl = display.lastNull = l2 == 0L;
        if (!this.hooks(1) && !display.filters(1)) {
            return null;
        }
        boolean bl2 = display.mnemonicKeyHit;
        display.mnemonicKeyHit = true;
        long l4 = this.callWindowProc(l, 262, l2, l3);
        boolean bl3 = false;
        if (!display.mnemonicKeyHit) {
            bl3 = !this.sendKeyEvent(1, 262, l2, l3);
        }
        display.mnemonicKeyHit = bl2;
        return (bl3 |= display.mnemonicKeyHit) ? LRESULT.ONE : new LRESULT(l4);
    }

    LRESULT wmSysKeyDown(long l, long l2, long l3) {
        if (l2 != 121L && (l3 & 0x20000000L) == 0L) {
            return null;
        }
        switch ((int)l2) {
            case 115: {
                long l4 = l;
                while (OS.GetParent(l4) != 0L && OS.GetWindow(l4, 4) == 0L) {
                    l4 = OS.GetParent(l4);
                }
                int n = OS.GetWindowLong(l4, -16);
                if ((n & 0x80000) == 0) break;
                return null;
            }
        }
        switch ((int)l2) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((l3 & 0x40000000L) == 0L) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        int n = 0;
        if (OS.IsWinCE) {
            switch ((int)l2) {
                case 8: {
                    n = 8;
                    break;
                }
                case 13: {
                    n = 13;
                    break;
                }
                case 46: {
                    n = 127;
                    break;
                }
                case 27: {
                    n = 27;
                    break;
                }
                case 9: {
                    n = 9;
                }
            }
        } else {
            n = OS.MapVirtualKey((int)l2, 2);
        }
        boolean bl = this.display.lastVirtual = n == 0 || this.display.numpadKey((int)l2) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = (int)l2;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                switch (this.display.lastKey) {
                    case 106: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 111: {
                        return null;
                    }
                }
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            this.display.lastKey = (int)OS.CharLower((short)n);
            if (OS.IsWinNT) {
                return null;
            }
            if (l2 != 13L) {
                return null;
            }
            this.display.lastAscii = 13;
        }
        if (!this.sendKeyEvent(1, 260, l2, l3)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmSysKeyUp(long l, long l2, long l3) {
        return this.wmKeyUp(l, l2, l3);
    }

    LRESULT wmXButtonDblClk(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        int n = OS.HIWORD(l2) == 1 ? 4 : 5;
        this.sendMouseEvent(3, n, l, 523, l2, l3);
        lRESULT = this.sendMouseEvent(8, n, l, 525, l2, l3) ? new LRESULT(this.callWindowProc(l, 525, l2, l3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        return lRESULT;
    }

    LRESULT wmXButtonDown(long l, long l2, long l3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        display.xMouse = true;
        int n = OS.HIWORD(l2) == 1 ? 4 : 5;
        lRESULT = this.sendMouseEvent(3, n, l, 523, l2, l3) ? new LRESULT(this.callWindowProc(l, 523, l2, l3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != l) {
            OS.SetCapture(l);
        }
        return lRESULT;
    }

    LRESULT wmXButtonUp(long l, long l2, long l3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        int n = OS.HIWORD(l2) == 1 ? 4 : 5;
        lRESULT = this.sendMouseEvent(4, n, l, 524, l2, l3) ? new LRESULT(this.callWindowProc(l, 524, l2, l3)) : LRESULT.ZERO;
        int n2 = 19;
        if (display.xMouse) {
            n2 |= 0x60;
        }
        if ((l2 & (long)n2) == 0L && OS.GetCapture() == l) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    static {
        if (!OS.IsWinCE && OS.COMCTL32_VERSION < OS.VERSION(5, 80)) {
            System.out.println("***WARNING: SWT requires comctl32.dll version 5.80 or greater");
            System.out.println("***WARNING: Detected: " + OS.COMCTL32_MAJOR + "." + OS.COMCTL32_MINOR);
        }
        OS.InitCommonControls();
    }
}

